/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js;

import com.elixirtech.arch.ArchAction;
import com.elixirtech.arch.EditorPreferences;
import com.elixirtech.arch.ElixirAction;
import com.elixirtech.editor.JEditor;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSToolBar
extends JToolBar
implements CaretListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    JEditor m_Editor;
    private JLabel m_LineInfo;
    private JSpinner m_FontSize;
    private ElixirAction m_Cut = new CutAction();
    private ElixirAction m_Copy = new CopyAction();
    private ElixirAction m_Paste = new PasteAction();

    public JSToolBar(JEditor jEditor) {
        this.m_Editor = jEditor;
        this.m_Editor.addCaretListener(this);
        this.setRollover(true);
        this.setFloatable(false);
        this.add(this.m_Cut);
        this.add(this.m_Copy);
        this.add(this.m_Paste);
        this.addSeparator();
        JLabel jLabel = new JLabel(Bundle.ARCH.getString("JSToolBar.FONT_SIZE"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(jLabel);
        this.m_FontSize = new JSpinner(EditorPreferences.getFontSize());
        Dimension dimension = this.m_FontSize.getPreferredSize();
        dimension.width = 80;
        this.m_FontSize.setPreferredSize(dimension);
        this.m_FontSize.setMaximumSize(dimension);
        this.m_FontSize.addChangeListener(this);
        this.m_Editor.setFontSize(((Number)this.m_FontSize.getValue()).intValue());
        this.add(this.m_FontSize);
        this.add(Box.createHorizontalGlue());
        this.m_LineInfo = new JLabel();
        this.m_LineInfo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.m_LineInfo.setFont(UIManager.getFont("Tree.font"));
        Dimension dimension2 = this.m_LineInfo.getPreferredSize();
        dimension2.width = 150;
        this.m_LineInfo.setPreferredSize(dimension2);
        this.add(this.m_LineInfo);
        this.checkEnabled();
    }

    public void checkEnabled() {
        String string = this.m_Editor.getSelectedText();
        boolean bl = string != null && string.length() > 0;
        this.m_Cut.setEnabled(bl && this.m_Editor.isEditable());
        this.m_Copy.setEnabled(bl);
        this.m_Paste.setEnabled(this.m_Editor.isEditable());
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateLineCol();
        this.checkEnabled();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.m_Editor.setFontSize(((Number)this.m_FontSize.getValue()).intValue());
    }

    public void dispose() {
        this.m_FontSize.removeChangeListener(this);
    }

    protected void updateLineCol() {
        String string = I18NUtil.getString(Bundle.ARCH, "JSToolBar.LINECOLUMN", this.line(), this.column());
        this.m_LineInfo.setText(string);
    }

    protected int line() {
        return this.m_Editor.getCaretRow() + 1;
    }

    protected int column() {
        return this.m_Editor.getCaretColumn() + 1;
    }

    private class CutAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public CutAction() {
            super("Editor.Cut");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSToolBar.this.m_Editor.cut();
        }
    }

    private class CopyAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public CopyAction() {
            super("Editor.Copy");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSToolBar.this.m_Editor.copy();
        }
    }

    private class PasteAction
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public PasteAction() {
            super("Editor.Paste");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSToolBar.this.m_Editor.paste();
        }
    }
}

