/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.js.help.IInserter;
import com.elixirtech.arch.js.help.INode;
import com.elixirtech.arch.js.help.JSHelpUtil;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.js.LocalJavaScriptEngine;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.TopLeftLayoutManager;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.util.StringStepper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ScriptEditor {
    private static final String VALIDATE = Bundle.ARCH.getString("ScriptEditor.Validate");
    private static final String VALID = Bundle.ARCH.getString("ScriptEditor.Valid");
    private JPanel m_Panel;
    private JSplitPane m_SplitPane;
    private JEditor m_Editor;
    private JList m_Category;
    private JList m_SubCategory;
    private JList m_Function;
    private JButton m_Validate;
    private JPanel m_Operations;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ScriptEditor.class);

    public ScriptEditor() {
        this.buildUI();
    }

    public JComponent getComponent() {
        return this.m_Panel;
    }

    public void setEnabled(boolean bl) {
        this.m_Editor.setEnabled(bl);
        SwingUtil.setEnabled(this.m_Operations, bl);
    }

    public JEditor getEditor() {
        return this.m_Editor;
    }

    public void textChanged() {
        this.hideGreenTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        String string = this.m_Editor.getText();
        LocalJavaScriptEngine localJavaScriptEngine = new LocalJavaScriptEngine();
        ValidateReporter validateReporter = new ValidateReporter();
        try {
            localJavaScriptEngine.setErrorReporter((ErrorReporter)validateReporter);
            localJavaScriptEngine.validate("validate", string);
            this.showGreenTick();
        }
        catch (EvaluatorException evaluatorException) {
            int n = validateReporter.getColumn();
            int n2 = validateReporter.getRow();
            ElxLoggerJ elxLoggerJ = ElxLoggerJ.getLogger((String)"JavaScript");
            elxLoggerJ.warn((Object)evaluatorException.details());
            ElixirJ.userError(evaluatorException.details());
            int n3 = this.findPos(string, n2, n);
            if (n3 > 0) {
                this.m_Editor.setCaretPosition(n3);
            }
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Unknown exception: " + String.valueOf(exception)), (Throwable)exception);
        }
        finally {
            localJavaScriptEngine.dispose();
        }
        this.m_Editor.requestFocus();
    }

    protected void showGreenTick() {
        this.m_Validate.setText(VALID);
        this.m_Validate.setIcon(StandardIcons.GREEN_TICK);
    }

    protected void hideGreenTick() {
        if (this.m_Validate.getIcon() != null) {
            this.m_Validate.setIcon(null);
            this.m_Validate.setText(VALIDATE);
        }
    }

    protected int findPos(String string, int n, int n2) {
        int n3 = -1;
        --n;
        for (int i = 0; i < n && (n3 = string.indexOf(10, n3 + 1)) >= 0; ++i) {
        }
        if (n3 > 0 && n3 + n2 <= string.length()) {
            return n3 + n2;
        }
        return -1;
    }

    protected void buildUI() {
        this.m_Panel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_Editor = new JEditor("", REJavaScriptTypes.kit());
        this.m_Editor.getDocument().addDocumentListener(new CodeBlock((Object)this, "textChanged"));
        jPanel.add((Component)new JScrollPane(this.m_Editor), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(new JLabel(Bundle.ARCH.getString("ScriptEditor.Operations"))));
        this.m_Operations = new JPanel(new GridLayout(5, 3, 6, 4));
        this.m_Operations.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Operations.add(this.button("+"));
        this.m_Operations.add(this.button("="));
        this.m_Operations.add(this.button("("));
        this.m_Operations.add(this.button("-"));
        this.m_Operations.add(this.button("<"));
        this.m_Operations.add(this.button(")"));
        this.m_Operations.add(this.button("*"));
        this.m_Operations.add(this.button(">"));
        this.m_Operations.add(this.button("&"));
        this.m_Operations.add(this.button("/"));
        this.m_Operations.add(this.button("!"));
        this.m_Operations.add(this.button("|"));
        this.m_Operations.add(this.button("."));
        this.m_Operations.add(this.button(","));
        this.m_Operations.add(this.button("?"));
        jPanel3.add((Component)this.m_Operations, "Center");
        this.m_Validate = new JButton(VALIDATE);
        this.m_Validate.setMargin(new Insets(0, 0, 0, 0));
        this.m_Validate.addActionListener(new CodeBlock((Object)this, "validate"));
        jPanel3.add((Component)this.m_Validate, "South");
        JPanel jPanel4 = new JPanel(new TopLeftLayoutManager());
        jPanel4.add(jPanel3);
        jPanel.add((Component)jPanel4, "East");
        JPanel jPanel5 = new JPanel(new GridLayout(1, 3, 2, 0));
        this.m_Category = this.buildList();
        this.m_SubCategory = this.buildList();
        this.m_Function = this.buildList();
        this.m_Category.addListSelectionListener(new SL(this.m_Category, this.m_SubCategory));
        this.m_SubCategory.addListSelectionListener(new SL(this.m_SubCategory, this.m_Function));
        this.m_SubCategory.addMouseListener(new ML(this.m_SubCategory));
        this.m_Function.addMouseListener(new ML(this.m_Function));
        jPanel5.add(this.newPanel(Bundle.ARCH.getString("ScriptEditor.Category"), this.m_Category));
        jPanel5.add(this.newPanel(Bundle.ARCH.getString("ScriptEditor.SubCategory"), this.m_SubCategory));
        jPanel5.add(this.newPanel(Bundle.ARCH.getString("ScriptEditor.Feature"), this.m_Function));
        jPanel2.add((Component)jPanel5, "Center");
        this.m_SplitPane = new JSplitPane(0, jPanel, jPanel2);
        this.m_Panel.add(this.m_SplitPane);
        this.refresh();
    }

    public void refresh() {
        this.m_Category.setModel(this.listModel(JSHelpUtil.getCategories()));
    }

    protected JPanel newPanel(String string, JComponent jComponent) {
        JPanel jPanel = SwingFactory.newTitledPanel(new BorderLayout(), new JLabel(string));
        jPanel.add(new JScrollPane(jComponent));
        return jPanel;
    }

    protected JList buildList() {
        JList jList = SwingFactory.newList();
        jList.setCellRenderer(new LCellRenderer());
        return jList;
    }

    protected JButton button(String string) {
        JButton jButton = I18NBypass.newButton(string);
        jButton.addActionListener(new Inserter(string));
        jButton.setMargin(new Insets(0, 2, 0, 2));
        return jButton;
    }

    protected ListModel listModel(INode[] iNodeArray) {
        DefaultListModel<INode> defaultListModel = new DefaultListModel<INode>();
        for (int i = 0; i < iNodeArray.length; ++i) {
            defaultListModel.addElement(iNodeArray[i]);
        }
        return defaultListModel;
    }

    private static class ValidateReporter
    implements ErrorReporter {
        private StrBuffer m_Buffer = new StrBuffer();
        private boolean m_LocationSet;
        private int m_Row;
        private int m_Column;

        private ValidateReporter() {
        }

        public void warning(String string, String string2, int n, String string3, int n2) {
            String string4 = I18NUtil.getString(Bundle.ARCH, "ScriptEditor.WARNING", string, n, string3);
            this.m_Buffer.append(string4);
            this.m_Buffer.append("\n");
            if (!this.m_LocationSet) {
                this.m_Row = n;
                this.m_Column = n2;
                this.m_LocationSet = true;
            }
        }

        public void error(String string, String string2, int n, String string3, int n2) {
            String string4 = I18NUtil.getString(Bundle.ARCH, "ScriptEditor.ERROR", string, n, string3);
            this.m_Buffer.append(string4);
            this.m_Buffer.append("\n");
            if (!this.m_LocationSet) {
                this.m_Row = n;
                this.m_Column = n2;
                this.m_LocationSet = true;
            }
        }

        public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
            if (!this.m_LocationSet) {
                this.m_Row = n;
                this.m_Column = n2;
                this.m_LocationSet = true;
            }
            this.m_Buffer.append(string + "\n");
            return new EvaluatorException(this.m_Buffer.toString(), string2, n, string3, n2);
        }

        public int getRow() {
            return this.m_Row;
        }

        public int getColumn() {
            return this.m_Column;
        }
    }

    private class SL
    implements ListSelectionListener {
        private JList m_From;
        private JList m_To;

        public SL(JList jList, JList jList2) {
            this.m_From = jList;
            this.m_To = jList2;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            INode iNode = (INode)this.m_From.getSelectedValue();
            if (iNode == null) {
                this.m_To.setModel(new DefaultListModel());
            } else {
                this.m_To.setModel(ScriptEditor.this.listModel(iNode.getChildren()));
            }
            ScriptEditor.this.m_Editor.requestFocus();
        }
    }

    private class ML
    extends MouseAdapter {
        private JList m_List;

        public ML(JList jList) {
            this.m_List = jList;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object e;
            if (mouseEvent.getClickCount() == 2 && ScriptEditor.this.m_Editor.isEnabled() && (e = this.m_List.getSelectedValue()) instanceof IInserter && ScriptEditor.this.m_Editor.isEditable()) {
                ScriptEditor.this.m_Editor.cut();
                IInserter iInserter = (IInserter)e;
                int n = ScriptEditor.this.m_Editor.getCaretPosition();
                String string = iInserter.getInsertion();
                ScriptEditor.this.m_Editor.insert(string, n);
                int n2 = iInserter.getCaretOffset();
                int n3 = n + this.endPos(string, n2);
                if ((n += n2) == n3) {
                    ScriptEditor.this.m_Editor.setCaretPosition(n);
                } else {
                    ScriptEditor.this.m_Editor.setSelectionStart(n);
                    ScriptEditor.this.m_Editor.setSelectionEnd(n3);
                }
            }
            ScriptEditor.this.m_Editor.requestFocus();
        }

        private int endPos(String string, int n) {
            StringStepper stringStepper = new StringStepper(string);
            stringStepper.advance(n);
            int n2 = n;
            char c = stringStepper.getChar();
            while (!stringStepper.atEnd() && c != ')' && c != ',' && c != '[' && c != '.') {
                stringStepper.advance();
                c = stringStepper.getChar();
                ++n2;
            }
            return n2;
        }
    }

    private class Inserter
    implements ActionListener {
        private String m_String;

        public Inserter(String string) {
            this.m_String = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ScriptEditor.this.m_Editor.isEditable()) {
                int n = ScriptEditor.this.m_Editor.getCaretPosition();
                ScriptEditor.this.m_Editor.insert(this.m_String, n);
                ScriptEditor.this.m_Editor.setCaretPosition(n + this.m_String.length());
                ScriptEditor.this.m_Editor.requestFocus();
            }
        }
    }
}

