/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js.help;

import com.elixirtech.arch.js.help.BeanMethod;
import com.elixirtech.arch.js.help.IInserter;
import com.elixirtech.arch.js.help.INode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class Bean
extends INode.Node
implements IInserter {
    private String m_Name;
    private String m_ShortName;
    private INode[] m_Children;
    private static Set<String> m_InternalMethods = new HashSet<String>();

    public Bean(String string, String string2) {
        this.m_Name = string2;
        this.m_ShortName = string;
    }

    public Bean(String string) {
        this.m_Name = string;
        int n = this.m_Name.lastIndexOf(46);
        if (n >= 0) {
            this.m_ShortName = this.m_Name.substring(n + 1);
        }
    }

    @Override
    public String getRenderableName() {
        return this.m_ShortName;
    }

    @Override
    public Icon getRenderableIcon() {
        return null;
    }

    @Override
    public INode[] getChildren() {
        if (this.m_Children == null) {
            this.buildChildren();
        }
        return this.m_Children;
    }

    @Override
    public String getInsertion() {
        return this.m_ShortName;
    }

    @Override
    public int getCaretOffset() {
        return this.m_ShortName.length();
    }

    private void buildChildren() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(this.m_Name, true, classLoader);
            Method method = null;
            try {
                method = clazz.getMethod("isHidden", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Object[] objectArray = new Object[1];
            Method[] methodArray = clazz.getMethods();
            ArrayList<BeanMethod> arrayList = new ArrayList<BeanMethod>();
            this.m_Children = new INode[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i].getDeclaringClass() == Object.class || this.isInternal(methodArray[i])) continue;
                if (method != null) {
                    objectArray[0] = methodArray[i].getName();
                    Object object = method.invoke(clazz, objectArray);
                    if (Boolean.TRUE.equals(object)) continue;
                }
                arrayList.add(new BeanMethod(methodArray[i]));
            }
            this.m_Children = new INode[arrayList.size()];
            arrayList.toArray(this.m_Children);
            Arrays.sort(this.m_Children);
        }
        catch (Exception exception) {
            this.m_Children = EMPTY_NODES;
        }
    }

    private boolean isInternal(Method method) {
        return m_InternalMethods.contains(method.getName());
    }

    static {
        m_InternalMethods.add("cacheProperties");
        m_InternalMethods.add("copyAttrs");
        m_InternalMethods.add("dispose");
        m_InternalMethods.add("getIndexOffset");
        m_InternalMethods.add("getParentStyledElement");
        m_InternalMethods.add("getProperty");
        m_InternalMethods.add("getPropertyCount");
        m_InternalMethods.add("getPropertyIndex");
        m_InternalMethods.add("getPropertyName");
        m_InternalMethods.add("getPropertyNames");
        m_InternalMethods.add("getPropertyType");
        m_InternalMethods.add("getPropertyValue");
        m_InternalMethods.add("getResourceProvider");
        m_InternalMethods.add("getStaticPropertyCount");
        m_InternalMethods.add("getTagName");
        m_InternalMethods.add("isHidden");
        m_InternalMethods.add("isLocalPropertyValue");
        m_InternalMethods.add("isPropertyEditable");
        m_InternalMethods.add("loaded");
        m_InternalMethods.add("setPropertyValue");
        m_InternalMethods.add("shallowCopy");
        m_InternalMethods.add("clip");
        m_InternalMethods.add("getChunk");
        m_InternalMethods.add("getChunkPanel");
        m_InternalMethods.add("getId");
        m_InternalMethods.add("getSection");
        m_InternalMethods.add("getShape");
        m_InternalMethods.add("getSplit");
        m_InternalMethods.add("getStyle");
        m_InternalMethods.add("getTreeModel");
        m_InternalMethods.add("notifyChanged");
        m_InternalMethods.add("setShape");
        m_InternalMethods.add("setSplit");
        m_InternalMethods.add("setStyle");
    }
}

