/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js.help;

import com.elixirtech.arch.js.help.IInserter;
import com.elixirtech.arch.js.help.INode;
import com.elixirtech.util.StrBuffer;
import java.lang.reflect.Method;
import javax.swing.Icon;

public class BeanMethod
extends INode.Node
implements IInserter {
    private String m_Name;
    private String m_Display;
    private String m_Insert;
    private boolean m_HasParams;

    public BeanMethod(Method method) {
        this.m_Name = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        this.m_HasParams = classArray.length > 0;
        Class<?> clazz = method.getReturnType();
        StrBuffer strBuffer = new StrBuffer();
        strBuffer.append(this.m_Name);
        strBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            strBuffer.append(BeanMethod.name(classArray[i]));
            if (i >= classArray.length - 1) continue;
            strBuffer.append(',');
        }
        strBuffer.append(')');
        this.m_Insert = strBuffer.toString();
        if (clazz != null) {
            strBuffer.append(" : ");
            strBuffer.append(BeanMethod.name(clazz));
        }
        this.m_Display = strBuffer.toString();
    }

    @Override
    public String getInsertion() {
        return this.m_Insert;
    }

    @Override
    public int getCaretOffset() {
        if (this.m_HasParams) {
            return this.m_Name.length() + 1;
        }
        return this.m_Name.length() + 2;
    }

    @Override
    public String getRenderableName() {
        return this.m_Display;
    }

    @Override
    public Icon getRenderableIcon() {
        return null;
    }

    private static String name(Class<?> clazz) {
        if (clazz.isArray()) {
            return BeanMethod.name(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(".") + 1);
    }
}

