/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js.help;

import java.util.HashMap;
import java.util.Map;

public class ECMA {
    private static final Map<String, ECMAMethod> ArrayMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> BooleanMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> BuiltinMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> DateMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> GlobalMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> MathMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> ObjectMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> NumberMap = new HashMap<String, ECMAMethod>();
    private static final Map<String, ECMAMethod> StringMap = new HashMap<String, ECMAMethod>();

    public static ECMAMethod lookup(String string, String string2) {
        Map<String, ECMAMethod> map = null;
        if ("Array".equals(string)) {
            map = ArrayMap;
        }
        if ("Boolean".equals(string)) {
            map = BooleanMap;
        }
        if ("Elixir Extensions".equals(string)) {
            map = BuiltinMap;
        }
        if ("Date".equals(string)) {
            map = DateMap;
        }
        if ("Math".equals(string)) {
            map = MathMap;
        }
        if ("Object".equals(string)) {
            map = ObjectMap;
        }
        if ("Number".equals(string)) {
            map = NumberMap;
        }
        if ("String".equals(string)) {
            map = StringMap;
        }
        if ("Globals".equals(string)) {
            map = GlobalMap;
        }
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static void add(Map<String, ECMAMethod> map, ECMAMethod eCMAMethod) {
        String string = eCMAMethod.getName();
        map.put(string, eCMAMethod);
    }

    static {
        ECMA.add(ArrayMap, new ECMAMethod("constructor", "item1,...", "array"));
        ECMA.add(ArrayMap, new ECMAMethod("concat", "item1,...", "array"));
        ECMA.add(ArrayMap, new ECMAMethod("join", "separator", "string"));
        ECMA.add(ArrayMap, new ECMAMethod("pop", null, "object"));
        ECMA.add(ArrayMap, new ECMAMethod("push", "object", "number"));
        ECMA.add(ArrayMap, new ECMAMethod("reverse", null, "array"));
        ECMA.add(ArrayMap, new ECMAMethod("shift", null, "object"));
        ECMA.add(ArrayMap, new ECMAMethod("slice", "start,end", "array"));
        ECMA.add(ArrayMap, new ECMAMethod("sort", "comparefn", "array"));
        ECMA.add(ArrayMap, new ECMAMethod("splice", "start, deleteCount,...", "array"));
        ECMA.add(ArrayMap, new ECMAMethod("toLocaleString", null, "string"));
        ECMA.add(ArrayMap, new ECMAMethod("toString", null, "string"));
        ECMA.add(ArrayMap, new ECMAMethod("unshift", "item1,...", "number"));
        ECMA.add(BooleanMap, new ECMAMethod("constructor", "value", "boolean"));
        ECMA.add(BooleanMap, new ECMAMethod("toString", null, "string"));
        ECMA.add(BooleanMap, new ECMAMethod("valueOf", null, "boolean"));
        ECMA.add(BuiltinMap, new ECMAMethod("asDate", "string", "date"));
        ECMA.add(BuiltinMap, new ECMAMethod("asNumber", "string", "number"));
        ECMA.add(BuiltinMap, new ECMAMethod("dateDiff", "date,date,interval", "number"));
        ECMA.add(BuiltinMap, new ECMAMethod("isNull", "object", "boolean"));
        ECMA.add(BuiltinMap, new ECMAMethod("isNumber", "object", "boolean"));
        ECMA.add(BuiltinMap, new ECMAMethod("isString", "object", "boolean"));
        ECMA.add(BuiltinMap, new ECMAMethod("leftTrim", "string", "string"));
        ECMA.add(BuiltinMap, new ECMAMethod("offsetDate", "date,numYears,numMonths,numDays", "date"));
        ECMA.add(BuiltinMap, new ECMAMethod("offsetDays", "date, numDays", "date"));
        ECMA.add(BuiltinMap, new ECMAMethod("offsetMonths", "date, numMonths", "date"));
        ECMA.add(BuiltinMap, new ECMAMethod("offsetYears", "date, numYears", "date"));
        ECMA.add(BuiltinMap, new ECMAMethod("rightTrim", "string", "string"));
        ECMA.add(BuiltinMap, new ECMAMethod("strip", "string,char", "boolean"));
        ECMA.add(BuiltinMap, new ECMAMethod("trim", "string", "string"));
        ECMA.add(DateMap, new ECMAMethod("constructor", "year,month[,date[,hours[,minutes[,seconds[,ms]]]]]", "date"));
        ECMA.add(DateMap, new ECMAMethod("getDate", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getDay", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getFullYear", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getHours", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getMilliseconds", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getMinutes", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getMonth", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getSeconds", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getTimezoneOffset", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCDate", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCDay", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCFullYear", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCHours", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCMilliseconds", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCMinutes", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCMonth", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("getUTCSeconds", null, "number"));
        ECMA.add(DateMap, new ECMAMethod("parse", "string", "date"));
        ECMA.add(DateMap, new ECMAMethod("setDate", "date", "number"));
        ECMA.add(DateMap, new ECMAMethod("setFullYear", "year[,month[,date]]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setMonth", "month[,date]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setHours", "hours[,mins[,secs[,ms]]]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setMilliseconds", "ms", "number"));
        ECMA.add(DateMap, new ECMAMethod("setMinutes", "mins[,secs[,ms]]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setSeconds", "secs[,ms]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setTime", "number", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCDate", "date", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCHours", "hours[,mins[,secs[,ms]]]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCFullYear", "year[,month[,date]]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCMilliseconds", "ms", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCMinutes", "mins[,secs[,ms]]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCMonth", "month[,date]", "number"));
        ECMA.add(DateMap, new ECMAMethod("setUTCSeconds", "secs[,ms]", "number"));
        ECMA.add(DateMap, new ECMAMethod("toDateString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("toLocaleDateString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("toLocaleString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("toLocaleTimeString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("toTimeString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("toString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("toUTCString", null, "string"));
        ECMA.add(DateMap, new ECMAMethod("valueOf", null, "date"));
        ECMA.add(GlobalMap, new ECMAMethod("eval", "x", "object"));
        ECMA.add(GlobalMap, new ECMAMethod("parseInt", "string[,radix]", "number"));
        ECMA.add(GlobalMap, new ECMAMethod("parseFloat", "string", "number"));
        ECMA.add(GlobalMap, new ECMAMethod("isNaN", "number", "boolean"));
        ECMA.add(GlobalMap, new ECMAMethod("isFinite", "number", "boolean"));
        ECMA.add(GlobalMap, new ECMAMethod("decodeURI", "encodedURI", "string"));
        ECMA.add(GlobalMap, new ECMAMethod("encodeURI", "uri", "string"));
        ECMA.add(MathMap, new ECMAMethod("abs", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("acos", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("asin", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("atan", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("atan2", "y,x", "number"));
        ECMA.add(MathMap, new ECMAMethod("ceil", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("cos", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("exp", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("floor", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("log", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("max", "value1,value2...", "number"));
        ECMA.add(MathMap, new ECMAMethod("min", "value1,value2...", "number"));
        ECMA.add(MathMap, new ECMAMethod("pow", "x,y", "number"));
        ECMA.add(MathMap, new ECMAMethod("random", null, "number"));
        ECMA.add(MathMap, new ECMAMethod("round", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("sin", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("sqrt", "x", "number"));
        ECMA.add(MathMap, new ECMAMethod("tan", "x", "number"));
        ECMA.add(ObjectMap, new ECMAMethod("constructor", "value", "object"));
        ECMA.add(ObjectMap, new ECMAMethod("hasOwnProperty", "name", "boolean"));
        ECMA.add(ObjectMap, new ECMAMethod("isPrototypeOf", "object", "boolean"));
        ECMA.add(ObjectMap, new ECMAMethod("propertyIsEnumerable", "name", "boolean"));
        ECMA.add(ObjectMap, new ECMAMethod("toLocaleString", null, "string"));
        ECMA.add(ObjectMap, new ECMAMethod("toString", null, "string"));
        ECMA.add(ObjectMap, new ECMAMethod("valueOf", null, "boolean"));
        ECMA.add(NumberMap, new ECMAMethod("constructor", "value", "number"));
        ECMA.add(NumberMap, new ECMAMethod("toExponential", "fractionDigits", "string"));
        ECMA.add(NumberMap, new ECMAMethod("toFixed", "fractionDigits", "string"));
        ECMA.add(NumberMap, new ECMAMethod("toPrecision", "precision", "string"));
        ECMA.add(NumberMap, new ECMAMethod("toLocaleString", null, "string"));
        ECMA.add(NumberMap, new ECMAMethod("toString", null, "string"));
        ECMA.add(NumberMap, new ECMAMethod("valueOf", null, "number"));
        ECMA.add(StringMap, new ECMAMethod("charAt", "pos", "string"));
        ECMA.add(StringMap, new ECMAMethod("charCodeAt", "pos", "number"));
        ECMA.add(StringMap, new ECMAMethod("concat", "s1,s2...", "string"));
        ECMA.add(StringMap, new ECMAMethod("constructor", "value", "string"));
        ECMA.add(StringMap, new ECMAMethod("indexOf", "searchString[,position]", "number"));
        ECMA.add(StringMap, new ECMAMethod("lastIndexOf", "searchString[,position]", "number"));
        ECMA.add(StringMap, new ECMAMethod("replace", "searchValue, replaceValue", "string"));
        ECMA.add(StringMap, new ECMAMethod("search", "regexp", "number"));
        ECMA.add(StringMap, new ECMAMethod("slice", "start,end", "string"));
        ECMA.add(StringMap, new ECMAMethod("split", "separator, limit", "string"));
        ECMA.add(StringMap, new ECMAMethod("substring", "start,end", "string"));
        ECMA.add(StringMap, new ECMAMethod("toLowerCase", null, "string"));
        ECMA.add(StringMap, new ECMAMethod("toLocaleLowerCase", null, "string"));
        ECMA.add(StringMap, new ECMAMethod("toString", null, "string"));
        ECMA.add(StringMap, new ECMAMethod("toUpperCase", null, "string"));
        ECMA.add(StringMap, new ECMAMethod("toLocaleUpperCase", null, "string"));
        ECMA.add(StringMap, new ECMAMethod("valueOf", null, "string"));
    }

    public static class ECMAMethod {
        private String m_Name;
        private String m_Params;
        private String m_Return;

        public ECMAMethod(String string, String string2, String string3) {
            this.m_Name = string;
            this.m_Params = string2;
            this.m_Return = string3;
        }

        public String getName() {
            return this.m_Name;
        }

        public String getParams() {
            return this.m_Params;
        }

        public String getReturn() {
            return this.m_Return;
        }
    }
}

