/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js.help;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.js.help.BasicNode;
import com.elixirtech.arch.js.help.Bean;
import com.elixirtech.arch.js.help.Category;
import com.elixirtech.arch.js.help.ECMACategory;
import com.elixirtech.arch.js.help.Global;
import com.elixirtech.arch.js.help.ICategorySupplier;
import com.elixirtech.arch.js.help.INode;
import com.elixirtech.arch.js.help.JavaScriptFunction;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.LocalJavaScriptEngine;
import com.elixirtech.js.ScriptException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;

public class JSHelpUtil {
    public static final boolean SHOW_ALL = false;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JSHelpUtil.class);
    private static Category[] m_Categories;

    public static INode[] getCategories() {
        INode[] iNodeArray;
        if (m_Categories == null) {
            JSHelpUtil.buildFixedCategories();
        }
        ArrayList<INode> arrayList = new ArrayList<INode>();
        for (int i = 0; i < m_Categories.length; ++i) {
            arrayList.add(m_Categories[i]);
        }
        Category category = new Category("Globals");
        JSHelpUtil.buildGlobals(category);
        arrayList.add(category);
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        if (iViewModel != null && (iNodeArray = iViewModel.getCurrentView()) instanceof ICategorySupplier) {
            List<INode> list = ((ICategorySupplier)iNodeArray).getCategories();
            for (INode iNode : list) {
                arrayList.add(iNode);
            }
        }
        iNodeArray = new Category[arrayList.size()];
        arrayList.toArray(iNodeArray);
        return iNodeArray;
    }

    private static void buildFixedCategories() {
        ArrayList<Category> arrayList = new ArrayList<Category>();
        Category category = new Category("JavaScript");
        JSHelpUtil.buildJavaScript(category);
        arrayList.add(category);
        m_Categories = new Category[arrayList.size()];
        arrayList.toArray(m_Categories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildJavaScript(Category category) {
        LocalJavaScriptEngine localJavaScriptEngine = new LocalJavaScriptEngine();
        try {
            Category category2 = new Category("Elixir Extensions");
            Scriptable scriptable = localJavaScriptEngine.getScope();
            JSHelpUtil.buildScope(scriptable, category2);
            category2.remove("elxgui");
            category2.add(new BasicNode("importScript(path)", "importScript()", 13));
            category.add(category2);
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Array", "new Array()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Boolean", "new Boolean()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Date", "new Date()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Function", "new Function()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Math", "Math"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Number", "new Number()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Object", "new Object()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "RegExp", "new RegExp()"));
            category.add(JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "String", "new String()"));
            Category category3 = JSHelpUtil.buildECMA((JavaScriptEngine)localJavaScriptEngine, "Globals", "this");
            category3.remove("elxgui");
            category3.remove("environment");
            category3.remove("Namespace");
            category3.remove("QName");
            category3.remove("XML");
            category3.remove("XMLList");
            category.add(category3);
        }
        finally {
            localJavaScriptEngine.dispose();
        }
    }

    private static Category buildECMA(JavaScriptEngine javaScriptEngine, String string, String string2) {
        ECMACategory eCMACategory = new ECMACategory(string);
        try {
            IdScriptableObject idScriptableObject = (IdScriptableObject)javaScriptEngine.evaluate("help", string2);
            if (idScriptableObject.getAllIds().length < 2) {
                idScriptableObject = (IdScriptableObject)idScriptableObject.getPrototype();
            }
            JSHelpUtil.buildScope(idScriptableObject, (Category)eCMACategory);
        }
        catch (ScriptException scriptException) {
            m_Log.warn((Object)("Can't read object: " + string));
        }
        catch (ClassCastException classCastException) {
            m_Log.debug((Object)("Can't read object: " + string + " (class cast error)"));
        }
        return eCMACategory;
    }

    private static void buildScope(Scriptable scriptable, Category category) {
        Object[] objectArray = scriptable.getIds();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = scriptable.get((String)objectArray[i], scriptable);
            if (object instanceof Function) {
                JavaScriptFunction javaScriptFunction = new JavaScriptFunction(category, String.valueOf(objectArray[i]), (Function)object, "elxfn.");
                if (!javaScriptFunction.isStandard()) continue;
                category.add(javaScriptFunction);
                continue;
            }
            category.add(new Global((String)objectArray[i]));
        }
    }

    private static void buildScope(IdScriptableObject idScriptableObject, Category category) {
        Object[] objectArray = idScriptableObject.getAllIds();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = idScriptableObject.get((String)objectArray[i], (Scriptable)idScriptableObject);
            if (object instanceof Function) {
                JavaScriptFunction javaScriptFunction = new JavaScriptFunction(category, String.valueOf(objectArray[i]), (Function)object, "");
                if (!javaScriptFunction.isStandard()) continue;
                category.add(javaScriptFunction);
                continue;
            }
            if (object == null || object instanceof com.elixirtech.js.Global || object instanceof NativeJavaObject || object instanceof NativeJavaPackage) continue;
            category.add(new Global((String)objectArray[i]));
        }
    }

    private static void buildGlobals(Category category) {
        IPanelView iPanelView;
        category.add(new Global("this"));
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        if (iViewModel != null && (iPanelView = iViewModel.getCurrentView()) instanceof ICategorySupplier) {
            List<INode> list = ((ICategorySupplier)((Object)iPanelView)).getGlobals();
            for (INode iNode : list) {
                category.add(iNode);
            }
        }
    }

    public static void buildPackage(Category category, String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(string + ".BeanMap", true, classLoader);
            Method method = clazz.getMethod("beanNames", new Class[0]);
            String[] stringArray = (String[])method.invoke(null, new Object[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                category.add(new Bean(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

