/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.js.help;

import com.elixirtech.arch.js.help.Category;
import com.elixirtech.arch.js.help.ECMA;
import com.elixirtech.arch.js.help.IInserter;
import com.elixirtech.arch.js.help.INode;
import com.elixirtech.util.StrBuffer;
import javax.swing.Icon;
import org.mozilla.javascript.Function;

public class JavaScriptFunction
extends INode.Node
implements IInserter {
    private Category m_Category;
    private String m_Name;
    private String m_Prefix;
    private String m_RenderableName;
    private String m_Insertion;
    private int m_CaretOffset;
    private boolean m_IsStandard;

    public JavaScriptFunction(Category category, String string, Function function, String string2) {
        this.m_Category = category;
        this.m_Name = string;
        this.m_Prefix = string2;
        ECMA.ECMAMethod eCMAMethod = ECMA.lookup(this.m_Category.getName(), this.m_Name);
        this.m_IsStandard = eCMAMethod != null;
        this.m_RenderableName = this.m_Name + this.buildName(eCMAMethod);
        if (this.m_Prefix != null) {
            this.m_Insertion = this.m_Prefix + this.m_Name + this.buildInsertion(eCMAMethod);
            this.m_CaretOffset = this.m_Prefix.length() + this.m_Name.length() + 1;
        } else {
            this.m_Insertion = this.m_Name + this.buildInsertion(eCMAMethod);
            this.m_CaretOffset = this.m_Name.length() + 1;
        }
    }

    public boolean isStandard() {
        return this.m_IsStandard;
    }

    @Override
    public String getRenderableName() {
        return this.m_RenderableName;
    }

    @Override
    public Icon getRenderableIcon() {
        return null;
    }

    @Override
    public String getInsertion() {
        return this.m_Insertion;
    }

    @Override
    public int getCaretOffset() {
        return this.m_CaretOffset;
    }

    private String buildName(ECMA.ECMAMethod eCMAMethod) {
        if (eCMAMethod != null) {
            StrBuffer strBuffer = new StrBuffer();
            strBuffer.append('(');
            String string = eCMAMethod.getParams();
            if (string != null) {
                strBuffer.append(string);
            }
            strBuffer.append(')');
            String string2 = eCMAMethod.getReturn();
            if (string2 != null) {
                strBuffer.append(" : " + string2);
            }
            return strBuffer.toString();
        }
        return "()";
    }

    private String buildInsertion(ECMA.ECMAMethod eCMAMethod) {
        if (eCMAMethod != null) {
            StrBuffer strBuffer = new StrBuffer();
            strBuffer.append('(');
            String string = eCMAMethod.getParams();
            if (string != null) {
                strBuffer.append(string);
            }
            strBuffer.append(')');
            return strBuffer.toString();
        }
        return "()";
    }
}

