/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.licence;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.licence.ILicence;
import com.elixirtech.arch.licence.IProduct;
import com.elixirtech.arch.licence.Licence$;
import com.elixirtech.arch.licence.LicenceException;
import com.elixirtech.arch.licence.LicenceReader;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;

public class Licence
implements ILicence {
    private final IProduct product;
    private final Option optReader;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Licence$.class.getDeclaredField("log$lzy1"));

    public static SimpleDateFormat DATE_FORMATTER() {
        return Licence$.MODULE$.DATE_FORMATTER();
    }

    public static Licence build(IProduct iProduct, LicenceReader licenceReader) {
        return Licence$.MODULE$.build(iProduct, licenceReader);
    }

    public static Option<LicenceReader> buildReader(IProduct iProduct) {
        return Licence$.MODULE$.buildReader(iProduct);
    }

    public static InputStream getInputStream(IProduct iProduct) {
        return Licence$.MODULE$.getInputStream(iProduct);
    }

    public static String getLicenceData(IProduct iProduct) {
        return Licence$.MODULE$.getLicenceData(iProduct);
    }

    public static LoggingInterface log() {
        return Licence$.MODULE$.log();
    }

    public Licence(IProduct product, Option<LicenceReader> optReader) {
        this.product = product;
        this.optReader = optReader;
    }

    public IProduct product() {
        return this.product;
    }

    public Option<LicenceReader> optReader() {
        return this.optReader;
    }

    public Licence(IProduct product) {
        this(product, Licence$.MODULE$.buildReader(product));
    }

    @Override
    public String getProperty(String key) {
        Option<LicenceReader> option = this.optReader();
        if (None$.MODULE$.equals(option)) {
            throw this.licenceNotFound();
        }
        if (option instanceof Some) {
            LicenceReader r = (LicenceReader)((Some)option).value();
            return r.getProperty(key);
        }
        throw new MatchError(option);
    }

    @Override
    public String[] getKeys() {
        Option<LicenceReader> option = this.optReader();
        if (None$.MODULE$.equals(option)) {
            throw this.licenceNotFound();
        }
        if (option instanceof Some) {
            LicenceReader r = (LicenceReader)((Some)option).value();
            return r.getKeys();
        }
        throw new MatchError(option);
    }

    @Override
    public boolean exists() {
        return this.optReader().isDefined();
    }

    @Override
    public boolean hasExpired() {
        Option<LicenceReader> option = this.optReader();
        if (None$.MODULE$.equals(option)) {
            throw this.licenceNotFound();
        }
        if (option instanceof Some) {
            LicenceReader r = (LicenceReader)((Some)option).value();
            return r.isExpired();
        }
        throw new MatchError(option);
    }

    @Override
    public void ensureValid() {
        Option<LicenceReader> option = this.optReader();
        if (option instanceof Some) {
            LicenceReader reader = (LicenceReader)((Some)option).value();
            if (reader.isExpired()) {
                throw new LicenceException("Licence expired");
            }
            String productName = reader.getProperty("product");
            if (!this.product().getProductName().equals(productName)) {
                throw new LicenceException("Incorrect product: " + productName);
            }
            String versionString = reader.getProperty("major-version");
            try {
                int major = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(versionString));
                if (this.product().getMajorVersion() != major) {
                    throw new LicenceException("Incorrect version: " + major);
                }
                this.verifyUser();
            }
            catch (NumberFormatException ex) {
                throw new LicenceException("Can't parse version: " + versionString);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw this.licenceNotFound();
        }
        throw new MatchError(option);
    }

    public void verifyUser() {
    }

    public Nothing$ licenceNotFound() {
        throw new LicenceException("Licence not found: " + this.product().getLicenceName() + "\nPlease ensure the licence file is in either ./ext or your user home directory");
    }
}

