/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.licence;

import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.licence.ILicenceHolder;
import com.elixirtech.arch.licence.IProduct;
import com.elixirtech.arch.licence.Licence;
import com.elixirtech.arch.licence.Licence$;
import com.elixirtech.arch.licence.LicenceException;
import com.elixirtech.arch.licence.LicenceReader;
import com.elixirtech.arch.licence.LicenceReader$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class Product
implements IProduct {
    private final String licenceName;
    private final String productName;
    private final int majorVersion;

    public Product(String licenceName, String productName, int majorVersion) {
        this.licenceName = licenceName;
        this.productName = productName;
        this.majorVersion = majorVersion;
    }

    public String licenceName() {
        return this.licenceName;
    }

    public String productName() {
        return this.productName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    @Override
    public String getLicenceName() {
        return this.licenceName();
    }

    @Override
    public String getProductName() {
        return this.productName();
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion();
    }

    @Override
    public void saveLicence(String licenceText) {
        Either<String, LicenceReader> either = LicenceReader$.MODULE$.read(licenceText);
        Either<String, LicenceReader> either2 = either;
        if (either2 instanceof Left) {
            String err = (String)((Left)either2).value();
            throw new LicenceException(err);
        }
        if (either2 instanceof Right) {
            LicenceReader lr = (LicenceReader)((Right)either2).value();
            try {
                Licence newLicence = Licence$.MODULE$.build(this, lr);
                newLicence.ensureValid();
                File licDir = new File(System.getProperty("user.home"));
                File lic = new File(licDir, this.licenceName());
                if (lic.exists()) {
                    this.backupLicence(licDir, lic);
                }
                ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                    OutputStreamWriter w = (OutputStreamWriter)arm.manage((Object)new OutputStreamWriter((OutputStream)new FileOutputStream(lic), "UTF-8"));
                    w.write(licenceText);
                });
                ILicenceHolder licenceHolder = (ILicenceHolder)Elixir$.MODULE$.get(ILicenceHolder.class);
                licenceHolder.setLicence(newLicence);
            }
            catch (IOException ex) {
                throw new LicenceException("Licence Error: " + ex, ex);
            }
            return;
        }
        throw new MatchError(either2);
    }

    public void backupLicence(File dir, File f) {
        String base = f.getName() + ".bak";
        int idx = 0;
        String lic = base;
        while (new File(dir, lic).exists()) {
            lic = base + idx;
            ++idx;
        }
        f.renameTo(new File(dir, lic));
    }
}

