/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class LogModel
extends AbstractTableModel
implements Comparable<LogModel> {
    private static final long serialVersionUID = 1L;
    private final String m_Name;
    private final int m_History;
    private final List<ILoggingEvent> m_Rows = new ArrayList<ILoggingEvent>();
    private static final Set<LogModel> LOGS = new TreeSet<LogModel>();
    private String[] m_Columns = COLUMNS;
    public static final String[] COLUMNS = new String[]{"Time", "Type", "Component", "Description"};

    public static LogModel[] getLogModels() {
        LogModel[] logModelArray = new LogModel[LOGS.size()];
        LOGS.toArray(logModelArray);
        return logModelArray;
    }

    public LogModel(String string, int n) {
        this.m_Name = string;
        this.m_History = n;
        LOGS.add(this);
    }

    public void setColumns(String[] stringArray) {
        this.m_Columns = stringArray;
    }

    @Override
    public int getColumnCount() {
        return this.m_Columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.m_Columns[n];
    }

    public String toString() {
        return this.m_Name;
    }

    public void serialize(PrintWriter printWriter) {
        printWriter.println("---- LOGMODEL: " + this.m_Name + " ----");
        printWriter.println();
    }

    public String getName() {
        return this.m_Name;
    }

    @Override
    public int compareTo(LogModel logModel) {
        return this.m_Name.compareTo(logModel.m_Name);
    }

    public void clear() {
        this.m_Rows.clear();
        this.fireTableDataChanged();
    }

    public void addEvent(ILoggingEvent iLoggingEvent) {
        int n = this.m_Rows.size();
        if (n == this.m_History) {
            this.m_Rows.remove(0);
            this.fireTableRowsDeleted(0, 0);
            --n;
        }
        this.m_Rows.add(iLoggingEvent);
        this.fireTableRowsInserted(n, n);
    }

    @Override
    public int getRowCount() {
        return this.m_Rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ILoggingEvent iLoggingEvent = this.m_Rows.get(n);
        if (n2 == 0) {
            return new Date(iLoggingEvent.getTimeStamp());
        }
        if (n2 == 1) {
            return iLoggingEvent.getLevel().toString();
        }
        if (n2 == 2) {
            return iLoggingEvent.getLoggerName();
        }
        if (n2 == 3) {
            return iLoggingEvent.getMessage();
        }
        return "";
    }
}

