/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.mime;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.mime.IMIMEManager;
import com.elixirtech.arch.mime.MIMEEntry;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class DefaultMIMEManager
implements IMIMEManager {
    public static final String FILENAME = "mimetypes";
    public static final String EXT = ".xml";
    private Map<String, MIMEEntry> m_Entries = new TreeMap<String, MIMEEntry>();
    private Map<String, MIMEEntry> m_Extensions = new TreeMap<String, MIMEEntry>();

    public DefaultMIMEManager() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            ElxLoggerJ.getLogger(DefaultMIMEManager.class).error((Object)("Unable to load mimetypes.xml: " + String.valueOf(iOException)), (Throwable)iOException);
        }
    }

    @Override
    public List<MIMEEntry> getEntries() {
        ArrayList<MIMEEntry> arrayList = new ArrayList<MIMEEntry>();
        arrayList.addAll(this.m_Entries.values());
        return arrayList;
    }

    @Override
    public void setEntries(List<MIMEEntry> list) {
        try {
            this.m_Entries.clear();
            this.m_Extensions.clear();
            for (MIMEEntry mIMEEntry : list) {
                this.addEntry(mIMEEntry);
            }
            this.save();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error saving mimetypes.xml: " + String.valueOf(iOException), iOException);
        }
    }

    @Override
    public MIMEEntry getEntryForFilename(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        string2 = string2.toLowerCase(Locale.ENGLISH);
        return this.m_Extensions.get(string2);
    }

    @Override
    public MIMEEntry getEntryForMIMEType(String string) {
        return this.m_Entries.get(string);
    }

    @Override
    public void addEntry(MIMEEntry mIMEEntry) {
        this.m_Entries.put(mIMEEntry.getMIMEType(), mIMEEntry);
        String[] stringArray = mIMEEntry.getExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_Extensions.put(stringArray[i], mIMEEntry);
        }
    }

    @Override
    public void removeEntry(String string) {
        MIMEEntry mIMEEntry = this.m_Entries.remove(string);
        if (mIMEEntry != null) {
            Iterator<Map.Entry<String, MIMEEntry>> iterator = this.m_Extensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, MIMEEntry> entry = iterator.next();
                if (mIMEEntry != entry.getValue()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        String[] stringArray;
        File file;
        Element element = new Element("mime-types");
        for (MIMEEntry comparable2 : this.m_Entries.values()) {
            file = new Element("mime-type");
            this.setAttribute((Element)file, "name", comparable2.getMIMEType());
            stringArray = comparable2.getExtensions();
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = new Element("extension");
                element2.setText(stringArray[i]);
                file.addContent((Content)element2);
            }
            for (Map.Entry entry : comparable2.getProperties().entrySet()) {
                Element element3 = new Element("property");
                this.setAttribute(element3, "name", (String)entry.getKey());
                element3.setAttribute("space", "preserve", Namespace.XML_NAMESPACE);
                element3.setText((String)entry.getValue());
                file.addContent((Content)element3);
            }
            element.addContent((Content)file);
        }
        File file2 = ElixirJ.getConfigDir();
        file = new File(file2, "mimetypes.xml");
        stringArray = new Document(element);
        XMLOutputter i = new XMLOutputter(Format.getPrettyFormat());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            i.output((Document)stringArray, (OutputStream)fileOutputStream);
        }
    }

    @Override
    public void load() throws IOException {
        TreeMap<String, MIMEEntry> treeMap = new TreeMap<String, MIMEEntry>();
        InputStream inputStream = this.getConfigStream();
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(inputStream);
            Element element = document.getRootElement();
            for (Element element2 : element.getChildren("mime-type")) {
                String string;
                String string2;
                Object object2;
                String string3 = element2.getAttributeValue("name");
                MIMEEntry mIMEEntry = new MIMEEntry(string3);
                for (Object object2 : element2.getChildren("extension")) {
                    string2 = object2.getTextNormalize();
                    if (!StringUtil.notEmpty(string2)) continue;
                    string = string2.toLowerCase(Locale.ENGLISH);
                    this.m_Extensions.put(string, mIMEEntry);
                    mIMEEntry.addExtension(string);
                }
                object2 = element2.getChildren("property").iterator();
                while (object2.hasNext()) {
                    string2 = (Element)object2.next();
                    string = string2.getAttributeValue("name");
                    String string4 = string2.getText();
                    if (string == null || string4 == null) continue;
                    mIMEEntry.addProperty(string, string4);
                }
                treeMap.put(string3, mIMEEntry);
            }
            this.m_Entries = treeMap;
        }
        catch (JDOMException jDOMException) {
            throw new IOException("Invalid XML in mimetypes.xml: " + String.valueOf((Object)jDOMException));
        }
    }

    private void setAttribute(Element element, String string, String string2) {
        if (string != null && string2 != null) {
            element.setAttribute(string, string2);
        }
    }

    private InputStream getConfigStream() {
        InputStream inputStream;
        File file = new File(ElixirJ.getConfigDir(), "mimetypes.xml");
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Locale locale = Locale.getDefault();
        String string = locale.getCountry();
        String string2 = locale.getVariant();
        if (StringUtil.notEmpty(string2) && (inputStream = classLoader.getResourceAsStream("config/mimetypes_" + string + " " + string2 + EXT)) != null) {
            return inputStream;
        }
        if (StringUtil.notEmpty(string) && (inputStream = classLoader.getResourceAsStream("config/mimetypes_" + string + EXT)) != null) {
            return inputStream;
        }
        return classLoader.getResourceAsStream("config/mimetypes.xml");
    }
}

