/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.mime;

import com.elixirtech.util.SoftException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class MIMEEntry
implements Comparable<MIMEEntry> {
    private String m_MIMEType;
    private String m_LaunchCommand = "";
    private Properties m_Properties = new Properties();
    private Set<String> m_Extensions = new TreeSet<String>();

    public MIMEEntry(String string) {
        assert (string != null);
        this.m_MIMEType = string;
    }

    public MIMEEntry(MIMEEntry mIMEEntry) {
        this.m_MIMEType = mIMEEntry.m_MIMEType;
        this.m_LaunchCommand = mIMEEntry.m_LaunchCommand;
        this.m_Properties.putAll((Map<?, ?>)mIMEEntry.m_Properties);
        this.m_Extensions.addAll(mIMEEntry.m_Extensions);
    }

    public String getMIMEType() {
        return this.m_MIMEType;
    }

    public String getLaunchCommand() {
        return this.m_LaunchCommand;
    }

    public Properties getProperties() {
        return this.m_Properties;
    }

    public String getProperty(String string) {
        return this.m_Properties.getProperty(string);
    }

    public void setMIMEType(String string) {
        this.m_MIMEType = string;
    }

    public void addProperty(String string, String string2) {
        this.m_Properties.put(string, string2);
    }

    public void removeProperty(String string) {
        this.m_Properties.remove(string);
    }

    public void addExtension(String string) {
        this.m_Extensions.add(string);
    }

    public void removeExtension(String string) {
        this.m_Extensions.remove(string);
    }

    public String[] getExtensions() {
        String[] stringArray = new String[this.m_Extensions.size()];
        this.m_Extensions.toArray(stringArray);
        return stringArray;
    }

    public void removeAllExtensions() {
        this.m_Extensions.clear();
    }

    @Override
    public int compareTo(MIMEEntry mIMEEntry) {
        return this.m_MIMEType.compareTo(mIMEEntry.m_MIMEType);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SoftException(cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof MIMEEntry) {
            MIMEEntry mIMEEntry = (MIMEEntry)object;
            if (!mIMEEntry.m_MIMEType.equals(this.m_MIMEType)) {
                return false;
            }
            if (!mIMEEntry.m_Properties.equals(this.m_Properties)) {
                return false;
            }
            return mIMEEntry.m_Extensions.equals(this.m_Extensions);
        }
        return false;
    }

    public int hashCode() {
        return this.m_MIMEType.hashCode();
    }
}

