/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.mime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Deprecated
public class MIMETypes {
    public static final String BMP = "image/bmp";
    public static final String BMP_ZIP = "application/x-bmp-zip";
    public static final String CSS = "text/css";
    public static final String CSV = "text/csv";
    public static final String CUBE = "application/x-adhoc-cube";
    public static final String DBF = "application/x-dbf";
    public static final String DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String DS = "text/x-datasource";
    public static final String EXCEL = "application/vnd.ms-excel";
    public static final String HTML = "text/html";
    public static final String HTML_ZIP = "application/x-html-zip";
    public static final String GLINT = "application/x-glint";
    public static final String GIF = "image/gif";
    public static final String IML = "application/x-rml-interactive";
    public static final String JOB = "text/x-job";
    public static final String JPEG = "image/jpeg";
    public static final String JPEG_ZIP = "application/x-jpeg-zip";
    public static final String LPT = "text/x-lpt";
    public static final String MAP = "text/x-map";
    public static final String PCL = "application/vnd.hp-pcl";
    public static final String PDF = "application/pdf";
    public static final String PML = "text/x-perspective";
    public static final String PNG = "image/png";
    public static final String PNG_ZIP = "application/x-png-zip";
    public static final String POSTSCRIPT = "application/postscript";
    public static final String PPT = "application/vnd.ms-powerpoint";
    public static final String PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String PRINT = "application/x-print";
    public static final String REPORT = "application/x-adhoc-report";
    public static final String RML = "text/x-report-template";
    public static final String RML_LOGICAL = "text/x-rml-logical";
    public static final String RML_TREE = "text/x-rml-logical-tree";
    public static final String RTF = "application/rtf";
    public static final String SHP = "application/x-esri-shapefile";
    public static final String SWF = "application/x-shockwave-flash";
    public static final String SVG = "image/svg+xml";
    public static final String SVG_ZIP = "application/x-svg-zip";
    public static final String TEXT = "text/plain";
    public static final String TIFF = "image/tiff";
    public static final String TIFF_ZIP = "application/x-tiff-zip";
    public static final String TRIGGER = "text/x-trigger";
    public static final String CALENDAR = "text/x-calendar";
    public static final String WBMP = "image/vnd.wap.wbmp";
    public static final String WBMP_ZIP = "application/x-wbmp-zip";
    public static final String XHTML = "application/xhtml+xml";
    public static final String XHTML_ZIP = "application/x-xhtml-zip";
    public static final String XML = "text/xml";
    public static final String XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final Map<String, String> TYPES = new HashMap<String, String>();
    private static final Map<String, String> EXTENSIONS = new HashMap<String, String>();
    private static final Set<String> ARCHIVE_TYPES = new HashSet<String>();
    private static final Set<String> NON_FRACTIONAL_TYPES = new HashSet<String>();

    public static String getExtension(String string) {
        String string2 = TYPES.get(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        return EXTENSIONS.get(string.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isArchiveMimeType(String string) {
        return ARCHIVE_TYPES.contains(string);
    }

    public static String getContents(String string) {
        if (HTML_ZIP.equals(string)) {
            return HTML;
        }
        if (JPEG_ZIP.equals(string)) {
            return JPEG;
        }
        if (PNG_ZIP.equals(string)) {
            return PNG;
        }
        if (SVG_ZIP.equals(string)) {
            return SVG;
        }
        if (XHTML_ZIP.equals(string)) {
            return XHTML;
        }
        if (BMP_ZIP.equals(string)) {
            return BMP;
        }
        if (TIFF_ZIP.equals(string)) {
            return TIFF;
        }
        if (WBMP_ZIP.equals(string)) {
            return WBMP;
        }
        return string;
    }

    public static boolean isUseFractionalMetrics(String string) {
        return !NON_FRACTIONAL_TYPES.contains(string);
    }

    public static String[] getMimeTypes() {
        return TYPES.keySet().toArray(new String[TYPES.keySet().size()]);
    }

    static {
        TYPES.put(BMP, ".bmp");
        TYPES.put(BMP_ZIP, ".bmp.zip");
        TYPES.put(CSS, ".css");
        TYPES.put(CSV, ".csv");
        TYPES.put(CUBE, ".cube");
        TYPES.put(DBF, ".dbf");
        TYPES.put(DOCX, ".docx");
        TYPES.put(DS, ".ds");
        TYPES.put(EXCEL, ".xls");
        TYPES.put(HTML, ".html");
        TYPES.put(HTML_ZIP, ".html.zip");
        TYPES.put(GLINT, ".glint");
        TYPES.put(IML, ".iml");
        TYPES.put(JOB, ".job");
        TYPES.put(GIF, ".gif");
        TYPES.put(JPEG, ".jpg");
        TYPES.put(JPEG_ZIP, ".jpg.zip");
        TYPES.put(LPT, ".lpt");
        TYPES.put(PCL, ".pcl");
        TYPES.put(PDF, ".pdf");
        TYPES.put(PML, ".pml");
        TYPES.put(PNG, ".png");
        TYPES.put(PNG_ZIP, ".png.zip");
        TYPES.put(POSTSCRIPT, ".ps");
        TYPES.put(PPT, ".ppt");
        TYPES.put(PPTX, ".pptx");
        TYPES.put(REPORT, ".report");
        TYPES.put(RML, ".rml");
        TYPES.put(RML_TREE, ".tree.rml");
        TYPES.put(RTF, ".rtf");
        TYPES.put(SHP, ".shp");
        TYPES.put(SWF, ".swf");
        TYPES.put(SVG, ".svg");
        TYPES.put(SVG_ZIP, ".svg.zip");
        TYPES.put(TEXT, ".txt");
        TYPES.put(TIFF, ".tif");
        TYPES.put(TIFF_ZIP, ".tif.zip");
        TYPES.put(TRIGGER, ".trigger");
        TYPES.put(CALENDAR, ".calendar");
        TYPES.put(WBMP, ".wbmp");
        TYPES.put(WBMP_ZIP, ".wbmp.zip");
        TYPES.put(XHTML_ZIP, ".xhtml.zip");
        TYPES.put(XHTML, ".xhtml");
        TYPES.put(XLSX, ".xlsx");
        TYPES.put(XML, ".xml");
        ARCHIVE_TYPES.add(HTML_ZIP);
        ARCHIVE_TYPES.add(JPEG_ZIP);
        ARCHIVE_TYPES.add(PNG_ZIP);
        ARCHIVE_TYPES.add(SVG_ZIP);
        ARCHIVE_TYPES.add(XHTML_ZIP);
        ARCHIVE_TYPES.add(BMP_ZIP);
        ARCHIVE_TYPES.add(WBMP_ZIP);
        ARCHIVE_TYPES.add(TIFF_ZIP);
        NON_FRACTIONAL_TYPES.add(HTML);
        NON_FRACTIONAL_TYPES.add(HTML_ZIP);
        NON_FRACTIONAL_TYPES.add(XHTML);
        NON_FRACTIONAL_TYPES.add(XHTML_ZIP);
        for (Map.Entry<String, String> entry : TYPES.entrySet()) {
            EXTENSIONS.put(entry.getValue().substring(1), entry.getKey());
        }
    }
}

