/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IRenderable2;
import com.elixirtech.arch.repository.BasicRepositoryActions;
import com.elixirtech.arch.repository.IFileTypeManager;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.v2.repository.FileObject;
import java.awt.datatransfer.DataFlavor;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.Icon;

public abstract class FileType
implements Comparable<FileType>,
IRenderable2 {
    private final String m_Name;
    private final String m_Extension;
    private final String m_DisplayName;
    private final Icon m_Icon;
    private final DataFlavor m_Flavor;

    public FileType(String string, String string2, Icon icon, DataFlavor dataFlavor) {
        this.m_Name = string;
        this.m_Extension = string2;
        this.m_DisplayName = FileType.getResourceString(this.m_Name);
        this.m_Icon = icon;
        this.m_Flavor = dataFlavor;
        ((IFileTypeManager)Elixir.get(IFileTypeManager.class)).addFileType(this);
    }

    public String getName() {
        return this.m_Name;
    }

    public String getExtension() {
        return this.m_Extension;
    }

    @Override
    public String getRenderableName() {
        return this.m_DisplayName;
    }

    @Override
    public Icon getRenderableIcon() {
        return this.m_Icon;
    }

    public DataFlavor getFlavor() {
        return this.m_Flavor;
    }

    public String getMimeType() {
        return null;
    }

    @Override
    public int compareTo(FileType fileType) {
        return this.m_Name.compareTo(fileType.m_Name);
    }

    public Action getDefaultAction(FileObject fileObject) {
        return BasicRepositoryActions.getOpenFile(fileObject);
    }

    public abstract Action getAddAction(FileObject var1);

    public abstract Action getPropertiesAction(FileObject var1);

    public abstract Action[] getPopupActions(FileObject var1);

    public IPanelView createView(FileObject fileObject) {
        return null;
    }

    public IPanelView createView(Object object) {
        return null;
    }

    protected static String getResourceString(String string) {
        try {
            return Bundle.ARCH.getString("FileType." + string.replace(' ', '_'));
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }
}

