/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.mime.IMIMEManager;
import com.elixirtech.arch.mime.MIMEEntry;
import com.elixirtech.arch.repository.DataPopupActions;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.IRepositoryPopupActions;
import com.elixirtech.arch.repository.RepositoryActions;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.repository.local.LocalFileSystem;
import com.elixirtech.v2.repository.FileObject;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class PopupActions
implements IRepositoryPopupActions {
    private JMenu buildAddMenu(RepositoryExplorer repositoryExplorer, FileObject fileObject) {
        JMenu jMenu = new JMenu(Bundle.ARCH.getString("PopupActions.ADD"));
        if (fileObject.canWrite()) {
            ArrayList<FileType> arrayList = new ArrayList<FileType>();
            arrayList.addAll(repositoryExplorer.getFileTypesJ());
            Collections.sort(arrayList);
            for (FileType fileType : arrayList) {
                Action action = fileType.getAddAction(fileObject);
                if (action == null) continue;
                jMenu.add(action);
            }
            jMenu.add(RepositoryActions.getAddFolder(fileObject));
        } else {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    @Override
    public JPopupMenu getFolderPopupActions(RepositoryExplorer repositoryExplorer, FileObject fileObject) {
        IMIMEManager iMIMEManager;
        MIMEEntry mIMEEntry;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = this.buildAddMenu(repositoryExplorer, fileObject);
        jPopupMenu.add(jMenu);
        if (fileObject.getFileSystem() instanceof LocalFileSystem && (mIMEEntry = (iMIMEManager = (IMIMEManager)Elixir.get(IMIMEManager.class)).getEntryForMIMEType("application/x-folder")) != null) {
            jPopupMenu.add(RepositoryActions.openExternal(fileObject, mIMEEntry));
        }
        jPopupMenu.add(RepositoryActions.getCopy());
        jPopupMenu.add(RepositoryActions.getPaste(fileObject));
        jPopupMenu.add(RepositoryActions.getRenameFolder(fileObject));
        jPopupMenu.add(RepositoryActions.getDelete());
        return jPopupMenu;
    }

    @Override
    public JPopupMenu getDataPopupActions(RepositoryExplorer repositoryExplorer, FileObject fileObject) {
        return DataPopupActions.getDataPopupActions(repositoryExplorer, fileObject);
    }

    @Override
    public JPopupMenu getRootPopupActions(RepositoryExplorer repositoryExplorer, FileObject fileObject) {
        IMIMEManager iMIMEManager;
        MIMEEntry mIMEEntry;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = this.buildAddMenu(repositoryExplorer, fileObject);
        jPopupMenu.add(jMenu);
        if (fileObject.getFileSystem() instanceof LocalFileSystem && (mIMEEntry = (iMIMEManager = (IMIMEManager)Elixir.get(IMIMEManager.class)).getEntryForMIMEType("application/x-folder")) != null) {
            jPopupMenu.add(RepositoryActions.openExternal(fileObject, mIMEEntry));
        }
        jPopupMenu.add(RepositoryActions.getCopy());
        jPopupMenu.add(RepositoryActions.getPaste(fileObject));
        return jPopupMenu;
    }
}

