/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirAction;
import com.elixirtech.arch.ElixirJ$;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.repository.ProxyRecentFiles$;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositoryPresentation;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.LCellRenderer2;
import com.elixirtech.ui.LCellRenderer2$;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import scala.Function1;
import scala.Option$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public class RecentFilesPanel
implements IViewModel.ModelListener {
    private final int COUNT;
    private final RepositoryExplorer repositoryExplorer;
    private final RepositoryPresentation presentation;
    private final DefaultListModel model;
    private final JList list;
    private IViewModel viewModel;
    private final Color c;
    private final Color c2;
    private final String title;
    private final Dimension sz;

    public RecentFilesPanel(RepositoryExplorer re) {
        this.COUNT = 5;
        this.repositoryExplorer = re;
        this.presentation = this.repositoryExplorer().getRepositoryPresentation();
        this.model = new DefaultListModel();
        this.list = new JList();
        this.list().setBackground(Color.WHITE);
        this.viewModel = (IViewModel)Elixir$.MODULE$.get(IViewModel.class);
        ProxyRecentFiles$.MODULE$.load(this.model());
        this.list().setFont(UIManager.getFont("Tree.font"));
        this.c = UIManager.getColor("Panel.background");
        this.c2 = new Color(this.c().getRGB() + 1);
        this.list().setBackground(this.c2());
        this.list().setCellRenderer(new RLCR());
        this.list().addMouseListener(new ML());
        this.list().setModel(this.model());
        this.title = Bundle.ARCH.getString("RecentFilesPanel.TITLE");
        this.list().setBorder(BorderFactory.createTitledBorder(this.title()));
        this.sz = this.list().getMinimumSize();
        this.sz().width = 30;
        this.list().setMinimumSize(this.sz());
        this.viewModel_$eq((IViewModel)Elixir$.MODULE$.get(IViewModel.class));
        this.viewModel().addModelListener(this);
    }

    public RepositoryExplorer repositoryExplorer() {
        return this.repositoryExplorer;
    }

    public RepositoryPresentation presentation() {
        return this.presentation;
    }

    public DefaultListModel<FileObject> model() {
        return this.model;
    }

    public JList<FileObject> list() {
        return this.list;
    }

    public IViewModel viewModel() {
        return this.viewModel;
    }

    public void viewModel_$eq(IViewModel x$1) {
        this.viewModel = x$1;
    }

    public Color c() {
        return this.c;
    }

    public Color c2() {
        return this.c2;
    }

    public String title() {
        return this.title;
    }

    public Dimension sz() {
        return this.sz;
    }

    @Override
    public void viewChanged() {
        Option$.MODULE$.apply((Object)this.viewModel().getCurrentView()).foreach((Function1)(JProcedure1 & Serializable)view -> Option$.MODULE$.apply((Object)view.getFileObject()).foreach((Function1)(JProcedure1 & Serializable)fo -> {
            this.addFirst((FileObject)fo);
            ProxyRecentFiles$.MODULE$.save(this.model());
        }));
    }

    public void refresh() {
        ProxyRecentFiles$.MODULE$.refresh();
        ProxyRecentFiles$.MODULE$.load(this.model());
    }

    public void init() {
        ProxyRecentFiles$.MODULE$.load(this.model());
    }

    public JComponent getComponent() {
        return this.list();
    }

    private void addFirst(FileObject fo) {
        Path path = fo.getPath();
        if (this.model().getSize() > 0) {
            FileObject fo2 = this.model().get(0);
            Path path2 = path;
            Path path3 = fo2.getPath();
            if (!(path2 != null ? !path2.equals(path3) : path3 != null)) {
                return;
            }
        }
        int i = 1;
        while (i < this.model().size()) {
            FileObject fo2 = this.model().get(i);
            Path path4 = path;
            Path path5 = fo2.getPath();
            if (!(path4 != null ? !path4.equals(path5) : path5 != null)) {
                this.model().remove(i);
                continue;
            }
            ++i;
        }
        if (this.model().size() >= this.COUNT) {
            this.model().removeRange(this.COUNT - 1, this.model().size() - 1);
        }
        this.model().add(0, fo);
    }

    public class ClearHistoryAction
    extends ElixirAction {
        public ClearHistoryAction() {
            if (RecentFilesPanel.this == null) {
                throw new NullPointerException();
            }
            super(Bundle.ARCH, "RecentFilesPanel.CLEAR_HISTORY");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RecentFilesPanel.this.model().removeAllElements();
            ProxyRecentFiles$.MODULE$.save(RecentFilesPanel.this.model());
        }

        public final /* synthetic */ RecentFilesPanel com$elixirtech$arch$repository$RecentFilesPanel$ClearHistoryAction$$$outer() {
            return RecentFilesPanel.this;
        }
    }

    public class ML
    extends MouseAdapter {
        public ML() {
            if (RecentFilesPanel.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.doPopup(ev);
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.doPopup(ev);
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                this.doPopup(ev);
                return;
            }
            int count = ev.getClickCount();
            if (SwingUtilities.isLeftMouseButton(ev) && count == 1) {
                int idx = RecentFilesPanel.this.list().locationToIndex(ev.getPoint());
                if (idx >= 0) {
                    if (RecentFilesPanel.this.list().getCellBounds(idx, idx).contains(ev.getPoint())) {
                        FileObject fo = RecentFilesPanel.this.model().get(idx);
                        Repository r = (Repository)Elixir$.MODULE$.get(Repository.class);
                        FileObject current = r.getFileJ(fo.getPath().toString());
                        if (current == null) {
                            ElixirJ$.MODULE$.userError(Bundle.ARCH.getString("RecentFilesPanel.FILE_NO_LONGER_AVAILABLE"));
                            v0 = RecentFilesPanel.this.model().remove(idx);
                        } else {
                            try {
                                if (current != null) {
                                    IPanelView pv = RecentFilesPanel.this.viewModel().openFile(current);
                                    if (pv == null) {
                                        RecentFilesPanel.this.model().remove(idx);
                                        v0 = BoxedUnit.UNIT;
                                    } else {
                                        v0 = BoxedUnit.UNIT;
                                    }
                                } else {
                                    v0 = BoxedUnit.UNIT;
                                }
                            }
                            catch (Throwable t) {
                                v0 = RecentFilesPanel.this.model().remove(idx);
                            }
                        }
                        RecentFilesPanel.this.list().clearSelection();
                        return;
                    }
                    return;
                }
                return;
            }
        }

        public void doPopup(MouseEvent ev) {
            JPopupMenu pm = new JPopupMenu();
            pm.add(new ClearHistoryAction());
            pm.show(RecentFilesPanel.this.list(), ev.getX(), ev.getY());
        }

        public final /* synthetic */ RecentFilesPanel com$elixirtech$arch$repository$RecentFilesPanel$ML$$$outer() {
            return RecentFilesPanel.this;
        }
    }

    public class RLCR
    extends LCellRenderer2<FileObject> {
        public RLCR() {
            if (RecentFilesPanel.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends FileObject> list, FileObject value, int row, boolean isSelected, boolean hasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            RLCR ret = this;
            ret.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            ret.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            ret.setFont(list.getFont());
            ret.setEnabled(list.isEnabled());
            ret.setBorder(hasFocus ? LCellRenderer2$.MODULE$.focusBorder() : LCellRenderer2$.MODULE$.noFocusBorder());
            ret.setText(RecentFilesPanel.this.presentation().getLabel(value));
            ret.setIcon(RecentFilesPanel.this.presentation().getIcon(value));
            ret.setToolTipText(RecentFilesPanel.this.presentation().getTip(value));
            ret.setBorder(null);
            return ret;
        }

        public final /* synthetic */ RecentFilesPanel com$elixirtech$arch$repository$RecentFilesPanel$RLCR$$$outer() {
            return RecentFilesPanel.this;
        }
    }
}

