/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.ArchAction;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.mime.MIMEEntry;
import com.elixirtech.arch.repository.IRepositoryActions;
import com.elixirtech.arch.repository.Paste;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.action.RefreshRepository;
import com.elixirtech.arch.wizard.AddFolderWizard;
import com.elixirtech.arch.wizard.RenameFolderWizard;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.repository.local.LocalFileObject;
import com.elixirtech.ui.ClipboardUtil;
import com.elixirtech.ui.JFileChooserEx;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class RepositoryActions
implements IRepositoryActions {
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RepositoryActions.class);

    @Override
    public Action getOpenExternalAction(FileObject fileObject, MIMEEntry mIMEEntry) {
        return RepositoryActions.openExternal(fileObject, mIMEEntry);
    }

    public static Action getRefreshRepository(Repository repository) {
        return new RefreshRepository(repository);
    }

    public static Action getAddFolder(FileObject fileObject) {
        return new AddFolder(fileObject);
    }

    public static Action getRenameFolder(FileObject fileObject) {
        return new RenameFolder(fileObject);
    }

    public static Action getCopy() {
        return new Copy();
    }

    public static Action getDownload(FileObject fileObject) {
        return new SaveLocal(fileObject);
    }

    public static Action getPaste(FileObject fileObject) {
        return new Paste(fileObject);
    }

    public static Action getDelete() {
        return new DeleteFileObject();
    }

    public static Action openExternal(FileObject fileObject, MIMEEntry mIMEEntry) {
        return new OpenExternal(fileObject, mIMEEntry);
    }

    private static class AddFolder
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private FileObject m_FileObject;

        public AddFolder(FileObject fileObject) {
            super("Repository.AddFolder");
            this.m_FileObject = fileObject;
            this.setEnabled(this.m_FileObject.canWrite());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("add folder " + String.valueOf(this.m_FileObject.getPath())));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new AddFolderWizard(this.m_FileObject));
        }
    }

    private static class RenameFolder
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private FileObject m_FileObject;

        public RenameFolder(FileObject fileObject) {
            super("Repository.RenameFolder");
            this.m_FileObject = fileObject;
            this.setEnabled(this.m_FileObject.canWrite());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("rename folder " + String.valueOf(this.m_FileObject.getPath())));
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new RenameFolderWizard(this.m_FileObject));
        }
    }

    private static class Copy
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public Copy() {
            super("Copy");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = System.getProperty("line.separator");
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
            Iterator<FileObject> iterator = repositoryExplorer.getSelectionJ().iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = iterator.next();
                String string2 = "repository:" + String.valueOf(fileObject.getPath());
                stringBuilder.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(string);
            }
            ClipboardUtil.setText(stringBuilder.toString());
        }
    }

    static class SaveLocal
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private FileObject m_FileObject;

        public SaveLocal(FileObject fileObject) {
            super("Repository.SaveLocal");
            this.m_FileObject = fileObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            JFileChooserEx jFileChooserEx = new JFileChooserEx();
            File file = new File(JFileChooserEx.getLastDirectory(), this.m_FileObject.getName());
            jFileChooserEx.setSelectedFile(file);
            if (jFileChooserEx.showSaveDialog(elixirFrame.getFrame()) == 0) {
                File file2 = jFileChooserEx.getSelectedFile();
                try {
                    FileUtil.copy(this.m_FileObject.getInputStream(), file2.getAbsolutePath());
                }
                catch (IOException iOException) {
                    String string = I18NUtil.getString(Bundle.ARCH, "RepositoryActions.ERROR_CANT_COPY", file2.getName());
                    ElixirJ.error(string, iOException);
                }
            }
        }
    }

    private static class DeleteFileObject
    extends ArchAction {
        private static final long serialVersionUID = 1L;

        public DeleteFileObject() {
            super("Repository.RemoveFileObject");
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
            this.enabled = true;
            for (FileObject fileObject : repositoryExplorer.getSelectionJ()) {
                this.enabled = this.enabled && fileObject.canWrite();
            }
            this.setEnabled(this.enabled);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
            Set<FileObject> set = repositoryExplorer.getSelectionJ();
            if (set.size() > 1) {
                String string = Bundle.ARCH.getString("RepositoryExplorer.ELIXIR_REPOSITORY");
                String object = Bundle.ARCH.getString("RepositoryExplorer.CONFIRM_DELETE");
                int n = JOptionPane.showConfirmDialog(repositoryExplorer.getComponent(), object, string, 0);
                if (n == 1) {
                    return;
                }
            }
            DeleteFileObject.removeChildren(set);
            for (FileObject fileObject : set) {
                m_Log.info((Object)("remove file object " + String.valueOf(fileObject.getPath())));
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    ElixirJ.error(I18NUtil.getString(Bundle.ARCH, "RepositoryActions.CANT_REMOVE", fileObject.getName()));
                }
            }
        }

        private static void removeChildren(Set<FileObject> set) {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            hashSet.addAll(set);
            for (FileObject fileObject : hashSet) {
                if (!DeleteFileObject.hasAncestor(fileObject.getParent(), set)) continue;
                set.remove(fileObject);
            }
        }

        private static boolean hasAncestor(FileObject fileObject, Set<FileObject> set) {
            if (fileObject == null) {
                return false;
            }
            if (set.contains(fileObject)) {
                return true;
            }
            return DeleteFileObject.hasAncestor(fileObject.getParent(), set);
        }
    }

    private static class OpenExternal
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private FileObject m_FileObject;
        private MIMEEntry m_Entry;

        public OpenExternal(FileObject fileObject, MIMEEntry mIMEEntry) {
            super("Repository.OpenExternal");
            this.m_FileObject = fileObject;
            this.m_Entry = mIMEEntry;
            boolean bl = this.m_FileObject instanceof LocalFileObject;
            boolean bl2 = false;
            if (bl && Desktop.isDesktopSupported()) {
                bl2 = Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
            }
            this.setEnabled(bl && bl2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            m_Log.info((Object)("open external program " + String.valueOf(this.m_FileObject.getPath())));
            File file = ((LocalFileObject)this.m_FileObject).getLocalFile();
            try {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(file);
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error opening file: " + String.valueOf(iOException)), (Throwable)iOException);
                ElixirJ.userError("Error opening file: " + String.valueOf(iOException));
            }
        }
    }
}

