/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.repository.RepositoryAttributes;
import com.elixirtech.arch.repository.RepositoryPresentation;
import com.elixirtech.repository.ExtraTodo;
import com.elixirtech.ui.tree.BasicTreeCellRenderer;
import com.elixirtech.v2.repository.FileObject;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIManager;

class RepositoryCellRenderer
extends BasicTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private RepositoryPresentation m_Presentation;
    private Font m_Plain;
    private Font m_Bold;

    public RepositoryCellRenderer(RepositoryPresentation repositoryPresentation) {
        this.m_Presentation = repositoryPresentation;
        this.m_Plain = UIManager.getFont("Tree.font");
        this.m_Bold = new Font(this.m_Plain.getFontName(), 1, this.m_Plain.getSize());
    }

    @Override
    public String getName(Object object) {
        Object object2;
        Font font = this.m_Plain;
        FileObject fileObject = ExtraTodo.asFileObjectJ(object);
        if (fileObject != null && (object2 = RepositoryAttributes.get(fileObject, "PanelView")) != null) {
            font = this.m_Bold;
        }
        this.setFont(font);
        this.setToolTipText(this.m_Presentation.getTip(object));
        return this.m_Presentation.getLabel(object);
    }

    @Override
    public Icon getIcon(Object object) {
        return this.m_Presentation.getIcon(object);
    }
}

