/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.arch.repository.filter.TypeFilter;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.repository.TreeNodeFilter;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RepositoryChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final TreeNodeFilter m_FileFilter;
    private RepositoryTree m_Tree;
    private boolean m_IsOk;
    private JButton m_Ok;
    private boolean m_CanSelectFolders;

    public RepositoryChooser(Frame frame, String string, FileType fileType) {
        this(frame, string, (TreeNodeFilter)new TypeFilter(fileType));
    }

    public RepositoryChooser(Frame frame, String string, TreeNodeFilter treeNodeFilter) {
        super(frame, true);
        this.setTitle(string);
        this.m_FileFilter = treeNodeFilter;
        this.init();
    }

    public RepositoryChooser(Dialog dialog, String string, FileType fileType) {
        this(dialog, string, (TreeNodeFilter)new TypeFilter(fileType));
    }

    public RepositoryChooser(Dialog dialog, String string, TreeNodeFilter treeNodeFilter) {
        super(dialog, true);
        this.setTitle(string);
        this.m_FileFilter = treeNodeFilter;
        this.init();
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        Repository repository = (Repository)Elixir.get(Repository.class);
        this.m_Tree = RepositoryTree.apply("RepositoryChooser:" + this.getTitle(), repository, this.m_FileFilter);
        this.m_Tree.addTreeSelectionListener(new CodeBlock((Object)this, "checkEnabled"));
        container.add(new JScrollPane(this.m_Tree));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        jPanel.add(this.m_Ok);
        jPanel.add(SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel")));
        container.add((Component)jPanel, "South");
        Bundle.ARCH_MAP.injectComponents("RepositoryChooser.", this);
        this.pack();
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.max(250, dimension.width);
        this.setSize(dimension);
        this.checkEnabled();
    }

    public void setCanSelectFolders(boolean bl) {
        this.m_CanSelectFolders = bl;
    }

    public void setSelection(FileObject fileObject) {
        this.m_Tree.setSelectionJ(fileObject);
        this.checkEnabled();
    }

    public FileObject getSelection() {
        return this.m_Tree.getSelectionJ();
    }

    public List<FileObject> getSelections() {
        return this.m_Tree.getSelectionsJ();
    }

    public void ok() {
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    @Override
    public void dispose() {
        if (this.m_Tree != null) {
            this.m_Tree.dispose();
        }
        super.dispose();
    }

    public void checkEnabled() {
        FileObject fileObject = this.m_Tree.getSelectionJ();
        if (this.m_CanSelectFolders) {
            this.m_Ok.setEnabled(fileObject != null);
        } else {
            this.m_Ok.setEnabled(fileObject != null && fileObject.isData());
        }
    }
}

