/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.IApplication;
import com.elixirtech.arch.IStateHolder;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.IRepositoryPopupActions;
import com.elixirtech.arch.repository.RepositoryCellRenderer;
import com.elixirtech.arch.repository.RepositoryExplorer$;
import com.elixirtech.arch.repository.RepositoryPresentation;
import com.elixirtech.arch.repository.explorer.DGL;
import com.elixirtech.arch.repository.explorer.DSL;
import com.elixirtech.arch.repository.explorer.DTL;
import com.elixirtech.arch.repository.explorer.FCL;
import com.elixirtech.arch.repository.explorer.ScriptResolver;
import com.elixirtech.arch.repository.explorer.TitleListener;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.js.IScriptResolver;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.repository.ExtraTodo$;
import com.elixirtech.repository.TreeNode;
import com.elixirtech.repository.tree.RepositoryTreeModel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.tree.TreeUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.FileSystem;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragSource;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class RepositoryExplorer
implements IStateHolder {
    private Repository m_Repository;
    private IApplication m_Application;
    private RepositoryTreeModel m_RepositoryTreeModel;
    private final HashMap<String, FileType> m_MimeTypes;
    private JTree m_Tree;
    private DragSource m_DragSource;
    private final HashMap m_FileTypes;
    private boolean m_AllowDragAndDrop;
    private RepositoryPresentation m_RepositoryPresentation;
    private DGL m_DGL;
    private DSL m_DSL;
    private DTL m_DTL;
    private final JPanel m_Panel;
    private final JToolBar m_ToolBar;
    private final Option m_Title;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RepositoryExplorer$.class.getDeclaredField("log$lzy1"));

    public static DataFlavor EXTERNAL_FILE_FLAVOR() {
        return RepositoryExplorer$.MODULE$.EXTERNAL_FILE_FLAVOR();
    }

    public static DataFlavor FILE_FLAVOR() {
        return RepositoryExplorer$.MODULE$.FILE_FLAVOR();
    }

    public static DataFlavor FOLDER_FLAVOR() {
        return RepositoryExplorer$.MODULE$.FOLDER_FLAVOR();
    }

    public static LoggingInterface log() {
        return RepositoryExplorer$.MODULE$.log();
    }

    public RepositoryExplorer(Repository m_Repository, IApplication m_Application) {
        this.m_Repository = m_Repository;
        this.m_Application = m_Application;
        this.m_RepositoryTreeModel = null;
        this.m_MimeTypes = new HashMap();
        this.m_Tree = null;
        this.m_DragSource = null;
        this.m_FileTypes = new HashMap();
        this.m_AllowDragAndDrop = true;
        this.m_RepositoryPresentation = null;
        this.m_DGL = new DGL(this);
        this.m_DSL = new DSL();
        this.m_DTL = new DTL(this);
        this.m_Panel = new JPanel(new BorderLayout());
        this.m_ToolBar = SwingFactory.newToolBar();
        this.m_ToolBar().setMargin(new Insets(2, 2, 3, 2));
        this.m_Title = this.buildTitle();
        this.buildToolBar();
        this.m_Title().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.addMouseListener(new TitleListener(this)));
        this.loadUI();
    }

    public Repository m_Repository() {
        return this.m_Repository;
    }

    public void m_Repository_$eq(Repository x$1) {
        this.m_Repository = x$1;
    }

    public IApplication m_Application() {
        return this.m_Application;
    }

    public void m_Application_$eq(IApplication x$1) {
        this.m_Application = x$1;
    }

    public JTree m_Tree() {
        return this.m_Tree;
    }

    public void m_Tree_$eq(JTree x$1) {
        this.m_Tree = x$1;
    }

    public DragSource m_DragSource() {
        return this.m_DragSource;
    }

    public void m_DragSource_$eq(DragSource x$1) {
        this.m_DragSource = x$1;
    }

    public HashMap<String, FileType> m_FileTypes() {
        return this.m_FileTypes;
    }

    public boolean m_AllowDragAndDrop() {
        return this.m_AllowDragAndDrop;
    }

    public void m_AllowDragAndDrop_$eq(boolean x$1) {
        this.m_AllowDragAndDrop = x$1;
    }

    public RepositoryPresentation m_RepositoryPresentation() {
        return this.m_RepositoryPresentation;
    }

    public void m_RepositoryPresentation_$eq(RepositoryPresentation x$1) {
        this.m_RepositoryPresentation = x$1;
    }

    public DGL m_DGL() {
        return this.m_DGL;
    }

    public void m_DGL_$eq(DGL x$1) {
        this.m_DGL = x$1;
    }

    public DSL m_DSL() {
        return this.m_DSL;
    }

    public void m_DSL_$eq(DSL x$1) {
        this.m_DSL = x$1;
    }

    public DTL m_DTL() {
        return this.m_DTL;
    }

    public void m_DTL_$eq(DTL x$1) {
        this.m_DTL = x$1;
    }

    public JPanel m_Panel() {
        return this.m_Panel;
    }

    public JToolBar m_ToolBar() {
        return this.m_ToolBar;
    }

    public Option<JLabel> m_Title() {
        return this.m_Title;
    }

    public Option<JLabel> buildTitle() {
        return None$.MODULE$;
    }

    public RepositoryTreeModel getRepositoryTreeModel() {
        return this.m_RepositoryTreeModel;
    }

    public JTree getTree() {
        return this.m_Tree();
    }

    public void loadUI() {
        this.m_Panel().removeAll();
        this.setToolbarEnabled(false);
        this.m_Panel().add((Component)this.m_ToolBar(), "North");
        JLabel loading = new JLabel(Bundle.ARCH.getString("RepositoryExplorer.LOADING"));
        loading.setOpaque(true);
        loading.setBackground(Color.WHITE);
        loading.setHorizontalAlignment(0);
        loading.setVerticalAlignment(1);
        this.m_Panel().add((Component)loading, "Center");
        this.m_Panel().validate();
        this.m_Panel().repaint();
        this.buildUI();
    }

    public void buildUI() {
        this.registerScriptResolver();
        this.m_RepositoryPresentation_$eq(this.createPresentation());
        this.m_RepositoryTreeModel = new RepositoryTreeModel("RepositoryExplorerModel", this.m_Repository(), this.m_RepositoryPresentation());
        this.m_Tree_$eq(new JTree(this.m_RepositoryTreeModel));
        this.m_Tree().setScrollsOnExpand(false);
        this.m_Tree().setCellRenderer(new RepositoryCellRenderer(this.m_RepositoryPresentation()));
        this.m_Tree().setRootVisible(false);
        this.m_Repository().addFileChangeListener(new FCL(this.m_RepositoryTreeModel, this.m_Tree()));
        ToolTipManager.sharedInstance().registerComponent(this.m_Tree());
        this.m_DragSource_$eq(new DragSource());
        this.m_DragSource().createDefaultDragGestureRecognizer(this.m_Tree(), 3, this.m_DGL());
        SwingUtil.setupDropTarget(this.m_Tree(), this.m_DTL());
        this.expandAllFileSystems();
        this.addTreeListener(this.m_Tree());
        this.constructPanel();
    }

    public void constructPanel() {
        this.m_Panel().removeAll();
        this.m_Panel().add((Component)this.m_ToolBar(), "North");
        this.m_Panel().add((Component)this.scroll(this.m_Tree()), "Center");
        this.m_Panel().validate();
        this.setToolbarEnabled(true);
        this.m_Panel().repaint();
    }

    public void refresh() {
        this.m_RepositoryTreeModel.refresh();
    }

    public RepositoryPresentation getRepositoryPresentation() {
        return this.m_RepositoryPresentation();
    }

    public void enableDragAndDrop(boolean b) {
        this.m_AllowDragAndDrop_$eq(b);
    }

    public boolean allowDragAndDrop() {
        return this.m_AllowDragAndDrop();
    }

    public Repository getRepository() {
        return this.m_Repository();
    }

    public void addFileType(FileType fileType) {
        RepositoryExplorer$.MODULE$.log().debug(() -> RepositoryExplorer.addFileType$$anonfun$1(fileType), Line$.MODULE$.apply(130), FullName$.MODULE$.apply("com.elixirtech.arch.repository.RepositoryExplorer.addFileType"));
        Option$.MODULE$.apply((Object)fileType.getExtension()).foreach((Function1 & Serializable)ext -> this.m_FileTypes().put((Object)ext.toLowerCase(Locale.ENGLISH), (Object)fileType));
        Option$.MODULE$.apply((Object)fileType.getMimeType()).foreach((Function1 & Serializable)mimeType -> this.m_MimeTypes.put(mimeType, (Object)fileType));
    }

    public scala.collection.immutable.Set<FileType> getFileTypes() {
        return this.m_FileTypes().values().toSet();
    }

    public List<FileType> getFileTypesJ() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.m_FileTypes().values().toList()).asJava();
    }

    public Option<FileType> getFileType(FileObject fo) {
        String ext = fo.getExtension().toLowerCase(Locale.ENGLISH);
        return this.m_FileTypes().get((Object)ext);
    }

    public FileType getFileTypeJ(FileObject fo) {
        String ext = fo.getExtension().toLowerCase(Locale.ENGLISH);
        return (FileType)this.m_FileTypes().get((Object)ext).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<FileType> getFileType(String mimeType) {
        return this.m_MimeTypes.get((Object)mimeType);
    }

    public FileType getFileTypeJ(String mimeType) {
        return (FileType)this.m_MimeTypes.get((Object)mimeType).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void select(FileObject fo) {
        TreeNode node = ExtraTodo$.MODULE$.getFileObjectTreeNode(fo);
        TreePath tp = this.m_RepositoryTreeModel.getTreePath(node);
        if (tp != null) {
            this.m_Tree().setSelectionPath(tp);
            this.m_Tree().scrollPathToVisible(tp);
            return;
        }
    }

    public scala.collection.immutable.Set<FileObject> getSelection() {
        Object[] paths = this.m_Tree().getSelectionPaths();
        Object object = Predef$.MODULE$.refArrayOps(paths);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)path -> ExtraTodo$.MODULE$.asFileObjectJ(path.getLastPathComponent()), ClassTag$.MODULE$.apply(FileObject.class))).toSet();
    }

    public java.util.Set<FileObject> getSelectionJ() {
        Object[] paths = this.m_Tree().getSelectionPaths();
        Object object = Predef$.MODULE$.refArrayOps(paths);
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)path -> ExtraTodo$.MODULE$.asFileObjectJ(path.getLastPathComponent()), ClassTag$.MODULE$.apply(FileObject.class))).toSet()).asJava();
    }

    public void select(scala.collection.immutable.Set<FileObject> fos) {
        this.m_Tree().clearSelection();
        fos.foreach((Function1)(JProcedure1 & Serializable)fo -> {
            TreeNode node = ExtraTodo$.MODULE$.getFileObjectTreeNode((FileObject)fo);
            Option$.MODULE$.apply((Object)this.m_RepositoryTreeModel.getTreePath(node)).foreach((Function1)(JProcedure1 & Serializable)_$2 -> this.m_Tree().addSelectionPath((TreePath)_$2));
        });
    }

    public void select(FileSystem fs) {
        TreeNode node = ExtraTodo$.MODULE$.getFileSystemTreeNode(fs);
        TreePath tp = this.m_RepositoryTreeModel.getTreePath(node);
        if (tp != null) {
            this.m_Tree().setSelectionPath(tp);
            return;
        }
    }

    public void expand(FileSystem fs) {
        TreeNode node = ExtraTodo$.MODULE$.getFileSystemTreeNode(fs);
        Option$.MODULE$.apply((Object)this.m_RepositoryTreeModel.getTreePath(node)).foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.m_Tree().expandPath((TreePath)_$3));
    }

    public void expand(FileObject fo) {
        TreeNode node = ExtraTodo$.MODULE$.getFileObjectTreeNode(fo);
        Option$.MODULE$.apply((Object)this.m_RepositoryTreeModel.getTreePath(node)).foreach((Function1)(JProcedure1 & Serializable)_$4 -> this.m_Tree().expandPath((TreePath)_$4));
    }

    public JComponent getComponent() {
        return this.m_Panel();
    }

    @Override
    public void saveAnyChanges() {
    }

    public JPopupMenu getPopupMenu(FileObject fo) {
        IRepositoryPopupActions popupActions = this.getPopupActions();
        if (fo.getOptParent().isDefined()) {
            if (fo.isFolder()) {
                return popupActions.getFolderPopupActions(this, fo);
            }
            return popupActions.getDataPopupActions(this, fo);
        }
        return popupActions.getRootPopupActions(this, fo);
    }

    public scala.collection.immutable.Set<Path> getExpanded() {
        return (scala.collection.immutable.Set)Option$.MODULE$.apply((Object)this.m_Tree().getPathForRow(0).getParentPath()).map((Function1 & Serializable)root -> {
            scala.collection.immutable.Set tps = (scala.collection.immutable.Set)Option$.MODULE$.apply(this.m_Tree().getExpandedDescendants((TreePath)root)).map((Function1 & Serializable)_$5 -> CollectionConverters$.MODULE$.EnumerationHasAsScala(_$5).asScala().toSet()).getOrElse(RepositoryExplorer::$anonfun$2);
            scala.collection.immutable.Set ret = (scala.collection.immutable.Set)((IterableOps)((IterableOps)tps.map((Function1 & Serializable)tp -> tp.getLastPathComponent())).flatMap((Function1 & Serializable)obj -> ExtraTodo$.MODULE$.asFileObject(obj))).map((Function1 & Serializable)_$6 -> _$6.getPath());
            return ret;
        }).getOrElse(RepositoryExplorer::getExpanded$$anonfun$2);
    }

    public void setExpanded(scala.collection.immutable.Set<Path> set) {
        Repository repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
        set.foreach((Function1)(JProcedure1 & Serializable)path -> repository.getFile(path.toString()).foreach((Function1)(JProcedure1 & Serializable)fo -> this.expand((FileObject)fo)));
    }

    public abstract IRepositoryPopupActions getPopupActions();

    public abstract void buildToolBar();

    public abstract void addTreeListener(JTree var1);

    public RepositoryPresentation createPresentation() {
        return new RepositoryPresentation(this);
    }

    public void setToolbarEnabled(boolean b) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.m_ToolBar().getComponents());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)_$7 -> _$7.setEnabled(b));
    }

    public JScrollPane scroll(JComponent component) {
        JScrollPane sp2 = new JScrollPane(component);
        sp2.setBorder(null);
        return sp2;
    }

    public void expandAllFileSystems() {
        TreeUtil.expandTree(this.m_Tree());
    }

    private void registerScriptResolver() {
        JavaScriptEngine.setResolver((IScriptResolver)new ScriptResolver());
    }

    private static final Object addFileType$$anonfun$1(FileType fileType$1) {
        return "Add File Type " + fileType$1.getMimeType() + " (" + fileType$1.getExtension() + ")";
    }

    private static final scala.collection.immutable.Set $anonfun$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final scala.collection.immutable.Set getExpanded$$anonfun$2() {
        return Predef$.MODULE$.Set().empty();
    }
}

