/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.filter.MultiTypeFilter;
import com.elixirtech.arch.repository.filter.TypeFilter;
import com.elixirtech.repository.TreeNodeFilter;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class RepositoryField
extends JPanel
implements ActionListener {
    private String m_Title;
    private TreeNodeFilter m_Filter;
    private JTextField m_Field;
    private JButton m_Dots;

    public RepositoryField(String string, FileType fileType) {
        this(string, new TypeFilter(fileType));
    }

    public RepositoryField(String string, FileType[] fileTypeArray) {
        this(string, MultiTypeFilter.forFileTypesJ(fileTypeArray));
    }

    public RepositoryField(String string, TreeNodeFilter treeNodeFilter) {
        this.m_Title = string;
        this.m_Filter = treeNodeFilter;
        this.m_Field = new JTextField();
        this.m_Dots = SwingFactory.newDotsButton(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Field, "Center");
        this.add((Component)this.m_Dots, "East");
    }

    public RepositoryField(String string, FileType fileType, String string2) {
        this(string, fileType);
        this.setURL(string2);
    }

    public RepositoryField(String string, FileType[] fileTypeArray, String string2) {
        this(string, fileTypeArray);
        this.setURL(string2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileObject fileObject;
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), this.m_Title, this.m_Filter);
        Repository repository = (Repository)Elixir.get(Repository.class);
        String string = this.m_Field.getText();
        if (string.startsWith("repository:") && (fileObject = repository.getFileJ(string.substring(11))) != null) {
            repositoryChooser.setSelection(fileObject);
        }
        repositoryChooser.setLocationRelativeTo(this);
        elixirFrame.showModal(repositoryChooser);
        if (repositoryChooser.isOk()) {
            this.setURL("repository:" + String.valueOf(repositoryChooser.getSelection().getPath()));
        }
    }

    public Document getDocument() {
        return this.m_Field.getDocument();
    }

    public void setURL(String string) {
        this.m_Field.setText(string);
    }

    public String getURL() {
        return this.m_Field.getText();
    }
}

