/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.icons.FileIcons;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.remote.a2021.GitPushIgnoreHelper$;
import com.elixirtech.repository.ExtraTodo$;
import com.elixirtech.ui.IPresentation;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.FilePath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import javax.swing.Icon;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;

public class RepositoryPresentation
implements IPresentation {
    private final RepositoryExplorer re;

    public RepositoryPresentation(RepositoryExplorer re) {
        this.re = re;
    }

    @Override
    public String getLabel(Object o) {
        return (String)ExtraTodo$.MODULE$.asFilePath(o).map((Function1 & Serializable)fo -> fo.getPath().name()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String getTip(Object o) {
        return (String)ExtraTodo$.MODULE$.asFilePath(o).map((Function1 & Serializable)fo -> fo.getPath().toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Icon getIcon(Object o) {
        FilePath filePath;
        Option<FilePath> fp = ExtraTodo$.MODULE$.asFilePath(o);
        Option<FilePath> option = fp;
        if (option instanceof Some && (filePath = (FilePath)((Some)option).value()) instanceof FileObject) {
            FileObject fo = (FileObject)filePath;
            Icon icon = this.getFileIcon(fo);
            if (this.isWIP(fo)) {
                return new WorkInProgress(icon);
            }
            return icon;
        }
        return null;
    }

    public boolean isWIP(FileObject fo) {
        return GitPushIgnoreHelper$.MODULE$.isIgnore(fo);
    }

    public Icon getFileIcon(FileObject fo) {
        if (fo.isData()) {
            Option<FileType> option = this.re.getFileType(fo);
            if (option instanceof Some) {
                FileType ft = (FileType)((Some)option).value();
                return ft.getRenderableIcon();
            }
            if (None$.MODULE$.equals(option)) {
                return FileIcons.getIcon(fo.getExtension());
            }
            throw new MatchError(option);
        }
        if (fo.isFolder()) {
            return StandardIcons.FOLDER;
        }
        return FileIcons.UNKNOWN_FILE;
    }

    public static class WorkInProgress
    implements Icon {
        private final Icon icon;

        public WorkInProgress(Icon icon) {
            this.icon = icon;
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
            g.setColor(Color.MAGENTA);
            int x2 = x + this.getIconWidth();
            int xc = x + this.getIconWidth() / 2;
            int y1 = y + this.getIconHeight() / 4;
            int y2 = y + this.getIconHeight() / 2;
            Polygon poly = new Polygon(new int[]{x, xc, x}, new int[]{y, y1, y2}, 3);
            g.fillPolygon(poly);
            g.setColor(Color.BLACK);
            g.drawPolygon(poly);
            g.drawLine(x, y, x, y + this.getIconHeight());
        }
    }
}

