/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Path$;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositorySaveWizard$;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.EventWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.OnePageWizard;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.v2.swing.icons.Icon$;
import com.elixirtech.v2.swing.repository.RepositoryTree;
import com.elixirtech.v2.swing.repository.TreeNodeFilter;
import com.elixirtech.v2.swing.repository.TypeFilter;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BooleanRef;
import scala.runtime.function.JProcedure1;

public class RepositorySaveWizardPage
extends RelativeLayoutWizardPage
implements OnePageWizard.Page {
    private final FileObject original;
    private final Option ft;
    private RepositoryTree tree;
    private JTextField filename;
    private boolean isFinished;

    public RepositorySaveWizardPage(FileObject original) {
        this.original = original;
        super("Page", null);
        this.ft = Option$.MODULE$.apply((Object)original).flatMap((Function1 & Serializable)o -> RepositorySaveWizard$.MODULE$.getFileType((FileObject)o));
        this.tree = null;
        this.filename = null;
        this.isFinished = false;
        Bundle.ARCH_MAP.injectObject(null, this, "RepositorySaveWizard");
        this.setIcon(Icon$.MODULE$.filesystem());
    }

    public Option<FileType> ft() {
        return this.ft;
    }

    public JTextField filename() {
        return this.filename;
    }

    public void filename_$eq(JTextField x$1) {
        this.filename = x$1;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void isFinished_$eq(boolean x$1) {
        this.isFinished = x$1;
    }

    @Override
    public void setWizard(IWizard wizard) {
        super.setWizard(wizard);
        this.filename_$eq(this.addLabelledField("name"));
        this.filename().getDocument().addDocumentListener(new EventWatcher(this){
            private final /* synthetic */ RepositorySaveWizardPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void update() {
                this.$outer.typed();
            }
        });
        this.tree = new RepositoryTree((Option<TreeNodeFilter>)this.ft().map((Function1 & Serializable)ft -> new TypeFilter(ft.getExtension())));
        this.tree.peer().addTreeSelectionListener(new EventWatcher(this){
            private final /* synthetic */ RepositorySaveWizardPage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void update() {
                this.$outer.treeSel();
            }
        });
        this.m_Component.add("tree", this.tree.getScroller());
        Bundle.ARCH_MAP.injectComponents("RepositorySaveWizard.", this.m_Component);
        this.stickTop("name");
        this.putRight("name", "name-label", 10);
        this.putBelow("tree", "name", 5);
        this.stickLeft("tree");
        this.stickRight("tree");
        this.stickBottom("tree");
        Option$.MODULE$.apply((Object)this.original).foreach((Function1)(JProcedure1 & Serializable)o -> {
            this.filename().setText(o.getPathString());
            this.tree.setSelection((Option<FileObject>)Some$.MODULE$.apply(o));
        });
    }

    public void typed() {
        Option$.MODULE$.apply((Object)this.m_Wizard.getContainer()).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.updateButtons());
    }

    public void treeSel() {
        Option<FileObject> option = this.tree.getSelection();
        if (option instanceof Some) {
            FileObject fo = (FileObject)((Some)option).value();
            Object path = fo.isFolder() ? fo.getPathString() + "/" : fo.getPathString();
            this.filename().setText((String)path);
        } else if (None$.MODULE$.equals(option)) {
            this.filename().setText("");
        } else {
            throw new MatchError(option);
        }
        Option$.MODULE$.apply((Object)this.m_Wizard.getContainer()).foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.updateButtons());
    }

    public String getPath() {
        return this.filename().getText();
    }

    public String getPathWithExt() {
        String name = this.filename().getText();
        String ext = (String)this.ft().map((Function1 & Serializable)_$3 -> _$3.getExtension()).getOrElse(RepositorySaveWizardPage::$anonfun$2);
        Option option = Path$.MODULE$.apply(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(name), "repository:")).extension();
        if (option instanceof Some) {
            return name;
        }
        if (None$.MODULE$.equals(option)) {
            return name + "." + ext;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public boolean performFinish() {
        String title;
        String prompt;
        int option;
        String name;
        Repository r = (Repository)Elixir$.MODULE$.get(Repository.class);
        Option<FileObject> child = r.getFile(name = this.getPathWithExt());
        if (child.isDefined() && (option = JOptionPane.showConfirmDialog(this.m_Component, prompt = Bundle.ARCH.getString("RepositorySaveWizard.OVERWRITE_PROMPT"), title = Bundle.ARCH.getString("RepositorySaveWizard.SAVE_AS"), 0)) == 1) {
            return false;
        }
        this.isFinished_$eq(true);
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean isPageComplete() {
        BooleanRef ok = BooleanRef.create((boolean)true);
        this.setError(null);
        if (this.getPath().isEmpty()) {
            this.setError(Bundle.ARCH.getString("RepositorySaveWizard.FILENAME_REQUIRED"));
            ok.elem = false;
        } else if (this.getPath().endsWith("/")) {
            this.setError(Bundle.ARCH.getString("RepositorySaveWizard.FILENAME_REQUIRED"));
            ok.elem = false;
        } else {
            Repository r = (Repository)Elixir$.MODULE$.get(Repository.class);
            r.getFile(this.getPathWithExt()).foreach((Function1)(JProcedure1 & Serializable)c -> {
                if (c.isFolder()) {
                    this.setError(Bundle.ARCH.getString("RepositorySaveWizard.CANT_SAVE_AS_FOLDER"));
                    ok$1.elem = false;
                    return;
                }
                if (c.equals(this.original)) {
                    this.setError(Bundle.ARCH.getString("RepositorySaveWizard.ORIGINAL_FILE"));
                    return;
                }
                this.setError(Bundle.ARCH.getString("RepositorySaveWizard.FILE_EXISTS"));
            });
        }
        this.m_Wizard.getContainer().updateMessage();
        return ok.elem;
    }

    private static final String $anonfun$2() {
        return "unknown";
    }
}

