/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.arch.repository.SelectableCellRenderer;
import com.elixirtech.repository.TreeNode;
import com.elixirtech.repository.TreeNodeFilter;
import com.elixirtech.repository.tree.HideBackupFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class SelectableCellEditor
extends SelectableCellRenderer
implements TreeCellEditor,
ItemListener {
    private static final long serialVersionUID = 1L;
    private TreeNodeFilter m_Filter = new HideBackupFilter();
    private List<CellEditorListener> m_Listeners = new ArrayList<CellEditorListener>();
    private ChangeEvent m_ChangeEvent = new ChangeEvent(this);

    public SelectableCellEditor(JTree jTree, TreeCellRenderer treeCellRenderer, Set<TreeNode> set) {
        super(jTree, treeCellRenderer, set);
        this.m_CheckBox.addItemListener(this);
        if (treeCellRenderer instanceof Component) {
            ((Component)((Object)treeCellRenderer)).addMouseListener(new ML());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_CheckBox.isSelected()) {
            TreeNode treeNode = (TreeNode)this.m_Value;
            if (!treeNode.isLeaf()) {
                HashSet<TreeNode> hashSet = new HashSet<TreeNode>();
                this.subtree(treeNode, hashSet);
                this.m_Selected.addAll(hashSet);
                this.m_Tree.repaint();
            } else {
                this.m_Selected.add(treeNode);
            }
        } else {
            TreeNode treeNode = (TreeNode)this.m_Value;
            if (!treeNode.isLeaf()) {
                HashSet<TreeNode> hashSet = new HashSet<TreeNode>();
                this.subtree(treeNode, hashSet);
                this.m_Selected.removeAll(hashSet);
                this.m_Tree.repaint();
            } else {
                this.m_Selected.remove(treeNode);
            }
        }
        this.m_Tree.requestFocus();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        return this.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
    }

    @Override
    public void cancelCellEditing() {
        for (CellEditorListener cellEditorListener : this.m_Listeners) {
            cellEditorListener.editingCanceled(this.m_ChangeEvent);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (CellEditorListener cellEditorListener : this.m_Listeners) {
            cellEditorListener.editingStopped(this.m_ChangeEvent);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_Selected.contains(this.m_Value) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.add(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.remove(cellEditorListener);
    }

    public boolean inCheckBoxHitRegion(MouseEvent mouseEvent) {
        Rectangle rectangle = this.m_Tree.getRowBounds(this.m_Row);
        Dimension dimension = this.m_CheckBox.getSize();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
        return rectangle2.contains(mouseEvent.getPoint());
    }

    private void subtree(TreeNode treeNode, Set<TreeNode> set) {
        if (this.m_Filter.accept(treeNode)) {
            set.add(treeNode);
            int n = treeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.subtree(treeNode.getChild(i), set);
            }
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (!SelectableCellEditor.this.m_Tree.isExpanded(SelectableCellEditor.this.m_Row)) {
                    SelectableCellEditor.this.m_Tree.expandRow(SelectableCellEditor.this.m_Row);
                } else {
                    SelectableCellEditor.this.m_Tree.collapseRow(SelectableCellEditor.this.m_Row);
                }
            }
        }
    }
}

