/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.repository;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.repository.INotifier;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class SwingNotifier
implements INotifier {
    private final Component m_Parent;
    private ProgressMonitor m_ProgressMonitor;
    private boolean m_Cancelled;

    public SwingNotifier(Component component) {
        this.m_Parent = component;
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void setTotalCount(int n) {
        String string = Bundle.ARCH.getString("Paste");
        this.m_ProgressMonitor = new ProgressMonitor(this.m_Parent, string, "", 0, n);
    }

    @Override
    public boolean message(int n, String string) {
        if (!this.m_Cancelled) {
            this.m_ProgressMonitor.setProgress(n);
            this.m_ProgressMonitor.setNote(string);
            this.m_Cancelled = this.m_ProgressMonitor.isCanceled();
        }
        return !this.m_Cancelled;
    }

    @Override
    public boolean isOverwriteOk() {
        String string = Bundle.ARCH.getString("Paste");
        String string2 = Bundle.ARCH.getString("Repository.PasteWillOverwrite");
        int n = JOptionPane.showConfirmDialog(this.m_Parent, string2, string, 0);
        return n == 0;
    }

    @Override
    public void close() {
        this.m_ProgressMonitor.close();
    }
}

