/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.util.Properties;

public class Handler
extends URLStreamHandler {
    private static final String MAGIC_NAME = "java.protocol.handler.pkgs";
    private static final String PACKAGE = "com.elixirtech.arch";

    public static void init() {
        Properties properties = System.getProperties();
        Object object = (String)properties.get(MAGIC_NAME);
        if (object != null) {
            if (((String)object).indexOf(PACKAGE) < 0) {
                object = (String)object + "|com.elixirtech.arch";
            }
        } else {
            object = PACKAGE;
        }
        properties.put(MAGIC_NAME, object);
        System.setProperties(properties);
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return new ResourceConnection(uRL);
    }

    private static class ResourceConnection
    extends URLConnection {
        protected ResourceConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            ClassLoader classLoader;
            InputStream inputStream;
            String string = this.getURL().getPath();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((inputStream = (classLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(string)) == null) {
                throw new IOException(String.valueOf(this.getURL()) + " not found");
            }
            return inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new UnknownServiceException("URL-based Output not supported");
        }
    }
}

