/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.txt;

import com.elixirtech.arch.ArchAction;
import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.repository.BasicRepositoryActions;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.txt.Icons;
import com.elixirtech.arch.txt.TxtPanel;
import com.elixirtech.arch.txt.TxtWizard;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.v2.repository.FileObject;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;

public class TxtFileType
extends FileType {
    public static final DataFlavor TXT_FLAVOR = new DataFlavor("text/plain", null);

    public TxtFileType() {
        super("Text", "txt", Icons.TXT, TXT_FLAVOR);
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public Action getAddAction(FileObject fileObject) {
        return new AddTxt(fileObject);
    }

    @Override
    public Action getPropertiesAction(FileObject fileObject) {
        return new EditTxt(fileObject);
    }

    @Override
    public Action[] getPopupActions(FileObject fileObject) {
        return new Action[]{BasicRepositoryActions.getOpenFile(fileObject), this.getPropertiesAction(fileObject)};
    }

    @Override
    public IPanelView createView(FileObject fileObject) {
        try {
            return new TxtPanel(fileObject);
        }
        catch (IOException iOException) {
            ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(I18NUtil.getString(Bundle.ARCH, "Error.CANT_READ_FILE_X", fileObject.getName()), (Throwable)iOException);
            return null;
        }
    }

    private static class AddTxt
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private FileObject m_FileObject;

        public AddTxt(FileObject fileObject) {
            super("Repository.AddTxt");
            this.m_FileObject = fileObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new TxtWizard(this.m_FileObject));
        }
    }

    private static class EditTxt
    extends ArchAction {
        private static final long serialVersionUID = 1L;
        private FileObject m_FileObject;

        public EditTxt(FileObject fileObject) {
            super("Repository.OpenTxtProperties");
            this.m_FileObject = fileObject;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            elixirFrame.showWizard(new TxtWizard(this.m_FileObject));
        }
    }
}

