/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.txt;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.UINavigatorPath;
import com.elixirtech.arch.js.JSToolBar;
import com.elixirtech.arch.txt.Icons;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REPlain;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledEditorKit;

public class TxtPanel
implements IPanelView,
IDirtyState.Listener {
    private final JPanel m_Panel = new JPanel();
    private FileObject m_File;
    private JEditor m_Editor;
    private JSToolBar m_ToolBar;
    private List<PropertyChangeListener> m_Listeners = new ArrayList<PropertyChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TxtPanel(FileObject fileObject) throws IOException {
        this.m_Panel.setLayout(new BorderLayout());
        this.m_File = fileObject;
        StyledEditorKit styledEditorKit = REPlain.kit();
        this.m_Editor = new JEditor("", styledEditorKit);
        this.m_Editor.setEditable(fileObject.canWrite());
        this.m_ToolBar = new JSToolBar(this.m_Editor);
        InputStreamReader inputStreamReader = new InputStreamReader(fileObject.getInputStream(), "UTF-8");
        StringWriter stringWriter = new StringWriter();
        String string = System.getProperty("line.separator");
        try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringWriter.write(string2);
                stringWriter.write(string);
            }
        }
        this.m_Editor.setText(stringWriter.toString());
        this.m_Editor.setDirty(false);
        this.m_Editor.addDirtyListener(this);
        this.m_Panel.add((Component)this.m_ToolBar, "North");
        this.m_Panel.add((Component)new JScrollPane(this.m_Editor), "Center");
    }

    public void showUINavigator(UINavigatorPath uINavigatorPath) {
    }

    @Override
    public String getName() {
        if (this.m_File != null) {
            return this.m_File.getPath().toString();
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        return Icons.TXT;
    }

    @Override
    public JComponent getComponent() {
        return this.m_Panel;
    }

    @Override
    public FileObject getFileObject() {
        return this.m_File;
    }

    @Override
    public boolean canSave() {
        return this.m_Editor.isDirty();
    }

    @Override
    public boolean canSaveAs() {
        return true;
    }

    @Override
    public void save() throws IOException {
        String string = this.m_Editor.getText();
        try (OutputStreamWriter outputStreamWriter = null;){
            outputStreamWriter = new OutputStreamWriter(this.m_File.getOutputStream(), "UTF-8");
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            this.m_Editor.setDirty(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(FileObject fileObject) throws IOException {
        String string = this.m_Editor.getText();
        try (OutputStreamWriter outputStreamWriter = null;){
            this.m_File = fileObject;
            outputStreamWriter = new OutputStreamWriter(this.m_File.getOutputStream());
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            this.m_Editor.setDirty(false);
        }
    }

    @Override
    public void setCurrent(boolean bl) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Listeners.add(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Listeners.remove(propertyChangeListener);
    }

    @Override
    public void dispose() {
        this.m_ToolBar.dispose();
    }

    @Override
    public void dirtyStateChanged(IDirtyState iDirtyState) {
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        iViewModel.refreshView();
        SwingUtilities.invokeLater(new CodeBlock((Object)this.m_Editor, "requestFocus"));
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        Iterator<PropertyChangeListener> iterator = this.m_Listeners.iterator();
        if (iterator.hasNext()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            while (iterator.hasNext()) {
                PropertyChangeListener propertyChangeListener = iterator.next();
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }
}

