/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.txt;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.v2.repository.FileObject;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JTextField;

public class TxtWizard
extends Wizard {
    public static final String EXT = ".txt";
    final FileObject m_Parent;
    final FileObject m_Child;
    private final MainPage m_Page;

    public TxtWizard(FileObject fileObject) {
        super(null);
        if (fileObject.isFolder()) {
            this.m_Parent = fileObject;
            this.m_Child = null;
        } else {
            this.m_Parent = fileObject.getParent();
            this.m_Child = fileObject;
        }
        this.m_WindowTitle = this.getTitle();
        this.m_Page = new MainPage();
        this.m_Page.setWizard(this);
        this.m_Pages.add(this.m_Page);
    }

    private String getTitle() {
        if (this.m_Child != null) {
            return Bundle.ARCH.getString("TxtWizard.EDIT_TITLE");
        }
        return Bundle.ARCH.getString("TxtWizard.ADD_TITLE");
    }

    @Override
    public boolean performFinish() {
        this.m_Page.performFinish();
        return true;
    }

    public boolean isValidNewName(String object) {
        if (!((String)object).endsWith(EXT)) {
            object = (String)object + EXT;
        }
        FileObject fileObject = this.m_Parent.getChildJ((String)object);
        if (this.m_Child == null) {
            return fileObject == null;
        }
        return fileObject == null || fileObject == this.m_Child;
    }

    private class MainPage
    extends RelativeLayoutWizardPage {
        private JTextField m_Name;

        public MainPage() {
            super("Text", null);
            String string = TxtWizard.this.m_Child != null ? "TxtWizard.EDIT_TEXT" : "TxtWizard.ADD_TEXT";
            this.setTitle(Bundle.ARCH.getString(string));
            this.setMessage(Bundle.ARCH.getString("TxtWizard.MESSAGE"));
        }

        public void performFinish() {
            Object object = this.m_Name.getText().replaceAll("\t", " ").trim();
            if (!((String)object).endsWith(TxtWizard.EXT)) {
                object = (String)object + TxtWizard.EXT;
            }
            if (TxtWizard.this.m_Child != null) {
                if (!TxtWizard.this.m_Child.getName().equals(object)) {
                    try {
                        TxtWizard.this.m_Child.rename((String)object);
                    }
                    catch (IOException iOException) {
                        ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(Bundle.ARCH.getString("TxtWizard.CANT_RENAME"), (Throwable)iOException);
                    }
                }
            } else {
                Object var2_3 = null;
                try {
                    FileObject fileObject = TxtWizard.this.m_Parent.createData((String)object);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream());
                    outputStreamWriter.close();
                    RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
                    repositoryExplorer.select(fileObject);
                    IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
                    iViewModel.openFile(fileObject);
                }
                catch (IOException iOException) {
                    ((IErrorHandler)Elixir.get(IErrorHandler.class)).error(Bundle.ARCH.getString("TxtWizard.CANT_CREATE"), (Throwable)iOException);
                }
            }
        }

        @Override
        public boolean canFlipToNextPage() {
            return false;
        }

        @Override
        public IWizardPage getNextPage() {
            return null;
        }

        @Override
        public boolean isPageComplete() {
            boolean bl;
            this.setError(null);
            String string = this.m_Name.getText().replaceAll("\t", " ").trim();
            boolean bl2 = bl = string.length() > 0;
            if (bl) {
                if (string.contains("/")) {
                    this.setError(Bundle.ARCH.getString("Wizard.NAME_CONTAINS_SLASH"));
                }
                if (!(bl = TxtWizard.this.isValidNewName(string))) {
                    this.setError(Bundle.ARCH.getString("Wizard.NAME_EXISTS"));
                }
            } else {
                this.setError(Bundle.ARCH.getString("Wizard.NAME_REQUIRED"));
            }
            this.m_Wizard.getContainer().updateMessage();
            return bl;
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_Name = this.addLabelledField("name");
            if (TxtWizard.this.m_Child != null) {
                this.m_Name.setText(TxtWizard.this.m_Child.getName());
            }
            this.m_Name.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
            Bundle.ARCH_MAP.injectComponents("Wizard.", this.m_Component);
            this.stickTop("name");
            this.putRight("name", "name-label", 10);
        }
    }
}

