/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.ui;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.SwingFactory;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class ArchLayout
extends RelativeLayout {
    public static final AttributeConstraint STICK_TOP = new AttributeConstraint("_container", AttributeType.TOP);
    public static final AttributeConstraint STICK_LEFT = new AttributeConstraint("_container", AttributeType.LEFT);
    public static final AttributeConstraint STICK_BOTTOM = new AttributeConstraint("_container", AttributeType.BOTTOM);
    public static final AttributeConstraint STICK_RIGHT = new AttributeConstraint("_container", AttributeType.RIGHT);
    private int m_LeftIndent = 0;

    public void putBelow(String string, String string2) {
        this.addConstraint(string, AttributeType.TOP, new AttributeConstraint(string2, AttributeType.BOTTOM));
    }

    public void putBelow(String string, String string2, int n) {
        this.addConstraint(string, AttributeType.TOP, new AttributeConstraint(string2, AttributeType.BOTTOM, n));
    }

    public void putAbove(String string, String string2) {
        this.addConstraint(string, AttributeType.BOTTOM, new AttributeConstraint(string2, AttributeType.TOP));
    }

    public void putAbove(String string, String string2, int n) {
        this.addConstraint(string, AttributeType.BOTTOM, new AttributeConstraint(string2, AttributeType.TOP, -n));
    }

    public void alignBelow(String string, String string2) {
        this.addConstraint(string, AttributeType.TOP, new AttributeConstraint(string2, AttributeType.BOTTOM));
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint(string2, AttributeType.LEFT));
    }

    public void alignBelow(String string, String string2, int n) {
        this.addConstraint(string, AttributeType.TOP, new AttributeConstraint(string2, AttributeType.BOTTOM, n));
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint(string2, AttributeType.LEFT));
    }

    public void alignAbove(String string, String string2, int n) {
        this.addConstraint(string, AttributeType.BOTTOM, new AttributeConstraint(string2, AttributeType.TOP, n));
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint(string2, AttributeType.LEFT));
    }

    public void alignLeft(String string, String string2) {
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint(string2, AttributeType.LEFT));
    }

    public void alignRight(String string, String string2) {
        this.addConstraint(string, AttributeType.RIGHT, new AttributeConstraint(string2, AttributeType.RIGHT));
    }

    public void alignTop(String string, String string2) {
        this.addConstraint(string, AttributeType.TOP, new AttributeConstraint(string2, AttributeType.TOP));
    }

    public void alignBottom(String string, String string2) {
        this.addConstraint(string, AttributeType.BOTTOM, new AttributeConstraint(string2, AttributeType.BOTTOM));
    }

    public void putRight(String string, String string2, boolean bl) {
        if (bl) {
            this.vCenter(string, string2);
        } else {
            this.alignTop(string, string2);
        }
        this.putRight(string, string2);
    }

    public void putRight(String string, String string2, boolean bl, int n) {
        if (bl) {
            this.vCenter(string, string2);
        } else {
            this.alignTop(string, string2);
        }
        this.putRight(string, string2, n);
    }

    public void putRight(String string, String string2) {
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint(string2, AttributeType.RIGHT));
    }

    public void putRight(String string, String string2, int n) {
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint(string2, AttributeType.RIGHT, n));
    }

    public void putLeft(String string, String string2) {
        this.addConstraint(string, AttributeType.RIGHT, new AttributeConstraint(string2, AttributeType.LEFT));
    }

    public void putLeft(String string, String string2, int n) {
        this.addConstraint(string, AttributeType.RIGHT, new AttributeConstraint(string2, AttributeType.LEFT, n));
    }

    public void stickLeft(String string) {
        this.addConstraint(string, AttributeType.LEFT, STICK_LEFT);
    }

    public void stickLeft(String string, int n) {
        this.addConstraint(string, AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, n));
    }

    public void stickRight(String string) {
        this.addConstraint(string, AttributeType.RIGHT, STICK_RIGHT);
    }

    public void stickRight(String string, int n) {
        this.addConstraint(string, AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -n));
    }

    public void stickTop(String string) {
        this.addConstraint(string, AttributeType.TOP, STICK_TOP);
    }

    public void stickTop(String string, int n) {
        this.addConstraint(string, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, n));
    }

    public void stickBottom(String string) {
        this.addConstraint(string, AttributeType.BOTTOM, STICK_BOTTOM);
    }

    public void stickBottom(String string, int n) {
        this.addConstraint(string, AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, -n));
    }

    public void hCenter(String string) {
        this.addConstraint(string, AttributeType.HORIZONTAL_CENTER, new AttributeConstraint("_container", AttributeType.HORIZONTAL_CENTER));
    }

    public void hCenter(String string, String string2) {
        this.addConstraint(string, AttributeType.HORIZONTAL_CENTER, new AttributeConstraint(string2, AttributeType.HORIZONTAL_CENTER));
    }

    public void vCenter(String string) {
        this.addConstraint(string, AttributeType.VERTICAL_CENTER, new AttributeConstraint("_container", AttributeType.VERTICAL_CENTER));
    }

    public void vCenter(String string, String string2) {
        this.addConstraint(string, AttributeType.VERTICAL_CENTER, new AttributeConstraint(string2, AttributeType.VERTICAL_CENTER));
    }

    public void setWidth(String string, String string2) {
        this.addConstraint(string, AttributeType.WIDTH, new AttributeConstraint(string2, AttributeType.WIDTH));
    }

    public void setHeight(String string, String string2) {
        this.addConstraint(string, AttributeType.HEIGHT, new AttributeConstraint(string2, AttributeType.HEIGHT));
    }

    public void setLeftIndent(int n) {
        this.m_LeftIndent = n;
    }

    public void addLabel(JComponent jComponent, String string) {
        if (!string.endsWith("-label")) {
            throw new IllegalArgumentException("label name must end with -label");
        }
        String string2 = string.substring(0, string.length() - 6);
        jComponent.add(SwingFactory.newLabel(string));
        this.stickLeft(string, this.m_LeftIndent);
        this.vCenter(string, string2);
    }

    public JLabel addLabel(JComponent jComponent, JLabel jLabel, String string) {
        jComponent.add(jLabel.getName(), jLabel);
        this.stickLeft(jLabel.getName(), this.m_LeftIndent);
        this.vCenter(jLabel.getName(), string);
        return jLabel;
    }

    public JLabel addLabel(JComponent jComponent, String string, JLabel jLabel) {
        jComponent.add(string + "-label", jLabel);
        this.stickLeft(string + "-label", this.m_LeftIndent);
        this.vCenter(string + "-label", string);
        return jLabel;
    }

    public void addLabelComponent(JComponent jComponent, JLabel jLabel, JComponent jComponent2) {
        jComponent.add(jLabel);
        jComponent.add(jComponent2);
        this.stickLeft(jLabel.getName(), this.m_LeftIndent);
        this.vCenter(jLabel.getName(), jComponent2.getName());
    }

    public JTextField addField(JComponent jComponent, String string, JLabel jLabel) {
        this.addLabel(jComponent, string, jLabel);
        JTextField jTextField = new JTextField();
        jComponent.add(string, jTextField);
        this.stickRight(string);
        return jTextField;
    }

    public JTextField addField(JComponent jComponent, String string) {
        JTextField jTextField = new JTextField();
        jComponent.add(string, jTextField);
        this.stickRight(string);
        return jTextField;
    }

    public JTextField addLabelledField(JComponent jComponent, String string) {
        String string2 = string + "-label";
        JLabel jLabel = SwingFactory.newLabel(string2);
        JTextField jTextField = SwingFactory.newTextField(string);
        jComponent.add(jLabel);
        jComponent.add(jTextField);
        this.stickLeft(string2, this.m_LeftIndent);
        this.vCenter(string2, string);
        this.stickRight(string);
        return jTextField;
    }

    public JTextField addLabelledFieldWithDots(JComponent jComponent, String string, ActionListener actionListener) {
        String string2 = string + "-label";
        String string3 = string + "-dots";
        JLabel jLabel = SwingFactory.newLabel(string2);
        JTextField jTextField = SwingFactory.newTextField(string);
        JButton jButton = SwingFactory.newDotsButton(string3, actionListener);
        jComponent.add(jLabel);
        jComponent.add(jTextField);
        jComponent.add(jButton);
        this.stickLeft(string2, this.m_LeftIndent);
        this.vCenter(string2, string);
        this.vCenter(string3, string);
        this.stickRight(string3);
        this.putLeft(string, string3);
        this.setHeight(string3, string);
        return jTextField;
    }

    public JComboBox addCombo(JComponent jComponent, String string, JLabel jLabel) {
        this.addLabel(jComponent, string, jLabel);
        JComboBox jComboBox = new JComboBox();
        jComponent.add(string, jComboBox);
        this.stickRight(string);
        return jComboBox;
    }

    public JComboBox addCombo(JComponent jComponent, String string) {
        JComboBox jComboBox = new JComboBox();
        jComponent.add(string, jComboBox);
        this.stickRight(string);
        return jComboBox;
    }

    public JComboBox addCombo(JComponent jComponent, String string, JLabel jLabel, Object[] objectArray) {
        this.addLabel(jComponent, string, jLabel);
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComponent.add(string, jComboBox);
        this.stickRight(string);
        return jComboBox;
    }

    public I18NComboBox addI18NCombo(JComponent jComponent, String string, JLabel jLabel, Name[] nameArray) {
        this.addLabel(jComponent, string, jLabel);
        I18NComboBox i18NComboBox = I18NComboBox.apply(nameArray);
        jComponent.add(string, i18NComboBox);
        this.stickRight(string);
        return i18NComboBox;
    }

    public JButton addButton(JComponent jComponent, String string, String string2) {
        JButton jButton = new JButton(string2);
        jComponent.add(string, jButton);
        return jButton;
    }

    public JButton addButton(JComponent jComponent, String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string2);
        jButton.addActionListener(actionListener);
        jComponent.add(string, jButton);
        return jButton;
    }

    public JSpinner addSpinner(JComponent jComponent, String string, JLabel jLabel) {
        this.addLabel(jComponent, string, jLabel);
        JSpinner jSpinner = new JSpinner();
        jComponent.add(string, jSpinner);
        this.stickRight(string);
        return jSpinner;
    }
}

