/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.wizard;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirJ$;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.ArchIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddFolderWizard
extends Wizard {
    private final Icon FILE_SYSTEM_ICON = ArchIcons.FILESYSTEM;
    private final MainPage m_MainPage;

    public AddFolderWizard(FileObject fo) {
        this.m_MainPage = new MainPage(fo);
        this.m_MainPage().setWizard(this);
        this.m_Pages.add(this.m_MainPage());
    }

    public Icon FILE_SYSTEM_ICON() {
        return this.FILE_SYSTEM_ICON;
    }

    public MainPage m_MainPage() {
        return this.m_MainPage;
    }

    @Override
    public boolean canFinish() {
        return this.m_MainPage().isPageComplete();
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        return this.m_MainPage().performFinish();
    }

    public class MainPage
    extends WizardPage
    implements ActionListener {
        private final FileObject m_FileObject;
        private final JTextField m_Name;

        public MainPage(FileObject fo) {
            if (AddFolderWizard.this == null) {
                throw new NullPointerException();
            }
            super("Main", null);
            this.m_FileObject = fo;
            this.m_Name = SwingFactory.newTextField("name");
            Bundle.ARCH_MAP.injectObject(null, this, "AddFolderWizard");
            this.setIcon(AddFolderWizard.this.FILE_SYSTEM_ICON());
        }

        public FileObject m_FileObject() {
            return this.m_FileObject;
        }

        public JTextField m_Name() {
            return this.m_Name;
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.m_Name().requestFocusInWindow();
                return;
            }
        }

        public boolean performFinish() {
            boolean bl;
            try {
                FileObject newFolder = this.m_FileObject().createFolder(this.m_Name().getText().replaceAll("\t", " ").trim());
                RepositoryExplorer re = (RepositoryExplorer)Elixir$.MODULE$.get(RepositoryExplorer.class);
                if (re != null) {
                    re.select(newFolder);
                }
                bl = true;
            }
            catch (IOException ex) {
                ElixirJ$.MODULE$.error(Bundle.ARCH.getString("AddFolderWizard.CANT_CREATE"), ex);
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean canFlipToNextPage() {
            return false;
        }

        @Override
        public IWizardPage getNextPage() {
            return null;
        }

        @Override
        public boolean isPageComplete() {
            boolean ret = false;
            String name = this.m_Name().getText().replaceAll("\t", " ").trim();
            if (name.isEmpty()) {
                this.setError(Bundle.ARCH.getString("Wizard.NAME_REQUIRED"));
            } else if (name.contains("/")) {
                this.setError(Bundle.ARCH.getString("Wizard.NAME_CONTAINS_SLASH"));
            } else if (this.m_FileObject().getChild(name).isDefined()) {
                this.setError(Bundle.ARCH.getString("Wizard.NAME_EXISTS"));
            } else {
                this.setError(null);
                ret = true;
            }
            IWizardContainer c = this.m_Wizard.getContainer();
            if (c != null) {
                c.updateMessage();
            }
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            this.m_Wizard.getContainer().finish();
        }

        @Override
        public void setWizard(IWizard newWizard) {
            super.setWizard(newWizard);
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.m_Component.setLayout(new BorderLayout());
            JPanel north = new JPanel(new BorderLayout());
            JLabel label = SwingFactory.newLabel("name-label");
            label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            north.add((Component)label, "West");
            this.m_Name().getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
            this.m_Name().addActionListener(this);
            north.add((Component)this.m_Name(), "Center");
            this.m_Component.add((Component)north, "North");
            Bundle.ARCH_MAP.injectComponents("Wizard.", this.m_Component);
        }

        public final /* synthetic */ AddFolderWizard com$elixirtech$arch$wizard$AddFolderWizard$MainPage$$$outer() {
            return AddFolderWizard.this;
        }
    }
}

