/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.wizard;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.ArchIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.v2.repository.FileObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameFileWizard
extends Wizard {
    static final Icon FILE_SYSTEM_ICON = ArchIcons.FILESYSTEM;
    private final MainPage m_MainPage;

    public RenameFileWizard(FileObject fileObject) {
        super(Bundle.ARCH.getString("RenameFileWizard.title"));
        this.m_MainPage = new MainPage(fileObject);
        this.m_MainPage.setWizard(this);
        this.m_Pages.add(this.m_MainPage);
    }

    @Override
    public boolean canFinish() {
        return this.m_MainPage.isPageComplete();
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        return this.m_MainPage.performFinish();
    }

    private static class MainPage
    extends WizardPage {
        private final FileObject m_Parent;
        private final FileObject m_FileObject;
        private JTextField m_Name;

        public MainPage(FileObject fileObject) {
            super("Main", null);
            this.m_FileObject = fileObject;
            this.m_Parent = this.m_FileObject.getParent();
            Bundle.ARCH_MAP.injectObject(null, this, "RenameFileWizard");
            this.setIcon(FILE_SYSTEM_ICON);
        }

        public boolean performFinish() {
            String string = this.m_Name.getText().trim();
            if (this.m_FileObject.getName().equals(string)) {
                return true;
            }
            try {
                this.m_FileObject.rename(string);
                return true;
            }
            catch (IOException iOException) {
                ElixirJ.error(Bundle.ARCH.getString("AddFileWizard.CANT_CREATE"), iOException);
                return false;
            }
        }

        @Override
        public boolean canFlipToNextPage() {
            return false;
        }

        @Override
        public IWizardPage getNextPage() {
            return null;
        }

        @Override
        public boolean isPageComplete() {
            boolean bl = false;
            String string = this.m_Name.getText().trim();
            if (string.length() == 0) {
                this.setError(Bundle.ARCH.getString("Wizard.NAME_REQUIRED"));
            } else if (!string.equals(this.m_FileObject.getName()) && this.m_Parent.getChildJ(string) != null) {
                this.setError(Bundle.ARCH.getString("Wizard.FILE_EXISTS"));
            } else {
                this.setError(null);
                bl = true;
            }
            IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
            if (iWizardContainer != null) {
                iWizardContainer.updateMessage();
            }
            return bl;
        }

        @Override
        public void setWizard(IWizard iWizard) {
            super.setWizard(iWizard);
            this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.m_Component.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = SwingFactory.newLabel("name-label");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            jPanel.add((Component)jLabel, "West");
            this.m_Name = SwingFactory.newTextField("name");
            this.m_Name.setText(this.m_FileObject.getName());
            this.m_Name.getDocument().addDocumentListener(new FieldWatcher(this.m_Wizard));
            jPanel.add((Component)this.m_Name, "Center");
            this.m_Component.add((Component)jPanel, "North");
            Bundle.ARCH_MAP.injectComponents("Wizard.", this.m_Component);
        }
    }
}

