/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.wizard;

import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedWizardPage
extends WizardPage
implements ChangeListener {
    protected JTabbedPane m_Tabs;
    protected ITabComponent m_Current;
    protected Map<Component, ITabComponent> m_Map = new HashMap<Component, ITabComponent>();

    public TabbedWizardPage(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Tabs = new JTabbedPane();
        this.m_Tabs.addChangeListener(this);
        this.m_Component.add(this.m_Tabs);
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.m_Current != null) {
                this.m_Current.entered();
            }
        } else if (this.m_Current != null) {
            this.m_Current.exited();
        }
    }

    public void addTab(ITabComponent iTabComponent) {
        JComponent jComponent = iTabComponent.getComponent();
        this.m_Map.put(jComponent, iTabComponent);
        this.m_Tabs.addTab(iTabComponent.getName(), jComponent);
    }

    public void removeAllTab() {
        this.m_Map.clear();
        this.m_Tabs.removeAll();
    }

    public void selectTab(ITabComponent iTabComponent) {
        this.m_Tabs.setSelectedComponent(iTabComponent.getComponent());
    }

    public boolean performFinish() {
        for (ITabComponent iTabComponent : this.m_Map.values()) {
            iTabComponent.performFinish();
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        ITabComponent iTabComponent = this.m_Map.get(this.m_Tabs.getSelectedComponent());
        if (iTabComponent != this.m_Current) {
            if (this.m_Current != null) {
                this.m_Current.exited();
            }
            this.m_Current = iTabComponent;
            this.updateMessage();
        }
    }

    public void updateMessage() {
        if (this.m_Current != null) {
            this.m_Current.entered();
            this.setMessage(this.m_Current.getMessage());
            IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
            if (iWizardContainer != null) {
                iWizardContainer.updateMessage();
            }
        }
    }
}

