/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.worker;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.v2.repository.FileObject;

public class CreatePanelView {
    private final FileObject m_File;
    private final Runnable m_After;

    public CreatePanelView(FileObject fileObject) {
        this(fileObject, null);
    }

    public CreatePanelView(FileObject fileObject, Runnable runnable) {
        assert (fileObject != null);
        this.m_File = fileObject;
        this.m_After = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPanelView showPanelView() {
        IErrorHandler iErrorHandler = (IErrorHandler)Elixir.get(IErrorHandler.class);
        iErrorHandler.setProgress("Loading");
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.setWaitCursor();
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        try {
            FileType fileType = repositoryExplorer.getFileTypeJ(this.m_File);
            if (fileType == null) {
                IPanelView iPanelView = null;
                return iPanelView;
            }
            IPanelView iPanelView = fileType.createView(this.m_File);
            IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
            if (iPanelView != null) {
                iViewModel.addView(iPanelView);
                iViewModel.setCurrentView(iPanelView);
                if (this.m_After != null) {
                    this.m_After.run();
                }
            }
            IPanelView iPanelView2 = iPanelView;
            return iPanelView2;
        }
        catch (Throwable throwable) {
            ElixirJ.error(Bundle.ARCH.getString("Error.PREPARING_VIEW"), throwable);
            IPanelView iPanelView = null;
            return iPanelView;
        }
        finally {
            iErrorHandler.setProgress(null);
            elixirFrame.setArrowCursor();
        }
    }
}

