/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.awt;

import com.elixirtech.awt.PropertyPanel;
import com.elixirtech.awt.UIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class PropertyDialog {
    protected boolean m_IsEditable;
    protected JDialog m_Dialog;
    protected JTabbedPane m_TabControl;
    protected JButton m_OK;
    protected JButton m_Cancel;
    protected static Point m_Position;

    public PropertyDialog(boolean bl) {
        this.m_IsEditable = bl;
        this.buildUI();
    }

    private void buildUI() {
        String string = this.m_IsEditable ? "Properties" : "Properties (Read Only)";
        this.m_Dialog = new JDialog(UIManager.getFrame(), string, true);
        this.m_Dialog.setDefaultCloseOperation(2);
        Container container = this.m_Dialog.getContentPane();
        container.setLayout(new BorderLayout());
        this.m_TabControl = new JTabbedPane(1);
        container.add((Component)this.m_TabControl, "Center");
        JPanel jPanel = new JPanel();
        this.m_OK = new JButton("OK");
        this.m_OK.addActionListener(new OKListener());
        this.m_OK.setEnabled(this.m_IsEditable);
        jPanel.add(this.m_OK);
        this.m_Cancel = new JButton("Cancel");
        this.m_Cancel.addActionListener(new CancelListener());
        jPanel.add(this.m_Cancel);
        container.add((Component)jPanel, "South");
    }

    public void showDialog() {
        this.showNow();
    }

    public void showNow() {
        this.m_Dialog.pack();
        this.loadProperties();
        this.m_Dialog.setVisible(true);
    }

    public void disposeDialog() {
        this.m_Dialog.dispose();
    }

    public void add(String string, PropertyPanel propertyPanel) {
        this.m_TabControl.addTab(string, (Component)propertyPanel);
    }

    public void add(PropertyPanel propertyPanel) {
        this.m_TabControl.addTab(propertyPanel.getPanelName(), (Component)propertyPanel);
    }

    public boolean apply() {
        if (this.verify()) {
            this.doApply();
            return true;
        }
        return false;
    }

    private boolean verify() {
        Component[] componentArray = this.m_TabControl.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (((PropertyPanel)componentArray[i]).verify()) continue;
            return false;
        }
        return true;
    }

    private void doApply() {
        Component[] componentArray = this.m_TabControl.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((PropertyPanel)componentArray[i]).apply();
        }
    }

    void loadProperties() {
        if (m_Position == null) {
            this.m_Dialog.setLocationRelativeTo(UIManager.getFrame());
        } else {
            this.m_Dialog.setLocation(PropertyDialog.m_Position.x, PropertyDialog.m_Position.y);
        }
        UIManager.constrainToScreen(this.m_Dialog);
    }

    void saveProperties() {
        m_Position = this.m_Dialog.getLocation();
    }

    Dialog getDialog() {
        return this.m_Dialog;
    }

    class OKListener
    implements ActionListener {
        OKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertyDialog.this.apply()) {
                PropertyDialog.this.saveProperties();
                PropertyDialog.this.getDialog().setVisible(false);
                PropertyDialog.this.getDialog().dispose();
            }
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertyDialog.this.saveProperties();
            PropertyDialog.this.getDialog().setVisible(false);
            PropertyDialog.this.getDialog().dispose();
        }
    }
}

