/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.awt;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JFrame;

public class UIManager {
    private static JFrame m_Frame;

    public static void constrainToScreen(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = window.getBounds();
        if (rectangle.x + rectangle.width > dimension.width) {
            rectangle.x = dimension.width - rectangle.width;
        }
        if (rectangle.y + rectangle.height > dimension.height) {
            rectangle.y = dimension.height - rectangle.height;
        }
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        window.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void setFrame(JFrame jFrame) {
        m_Frame = jFrame;
    }

    public static JFrame getFrame() {
        if (m_Frame == null) {
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            m_Frame = elixirFrame.getFrame();
        }
        return m_Frame;
    }

    public static void setFrameEnabled(boolean bl) {
        UIManager.getFrame().setEnabled(bl);
    }

    public static Cursor setCursor(Cursor cursor) {
        Cursor cursor2 = UIManager.getFrame().getCursor();
        UIManager.getFrame().setCursor(cursor);
        return cursor2;
    }

    public static void setWaitCursor() {
        UIManager.setCursor(new Cursor(3));
    }

    public static void setDefaultCursor() {
        UIManager.setCursor(new Cursor(0));
    }
}

