/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.barcode.IBarcodeBean;
import com.elixirtech.util.StringUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JComponent;

public class QRCodeBean
extends JComponent
implements IBarcodeBean {
    public static ElxLoggerJ m_Logger = ElxLoggerJ.getLogger(QRCodeBean.class);
    private static final int WHITE = -1;
    private static final int BLACK = -16777216;
    private String m_Encoding;
    private int m_Resolution = 2;
    private HashMap<EncodeHintType, Object> m_Hints = new HashMap();
    private String m_ErrorCorrection = "M";
    private QRCodeWriter m_Writer;
    private String m_Value;

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.m_Writer == null) {
            this.m_Writer = new QRCodeWriter();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        if (color == null) {
            color = Color.WHITE;
        }
        graphics2D.setColor(color);
        graphics2D.fill(this.getVisibleRect());
        try {
            int n = dimension.width * this.m_Resolution;
            int n2 = dimension.height * this.m_Resolution;
            this.m_Hints.put(EncodeHintType.ERROR_CORRECTION, this.getErrorCorrectionLevel());
            String string = this.getCharacterSet();
            if (StringUtil.notEmpty(string)) {
                this.m_Hints.put(EncodeHintType.CHARACTER_SET, string);
            }
            BitMatrix bitMatrix = this.m_Writer.encode(this.m_Value, BarcodeFormat.QR_CODE, n, n2, this.m_Hints);
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            int n3 = bitMatrix.getHeight();
            int n4 = bitMatrix.getWidth();
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    boolean bl = bitMatrix.get(j, i);
                    int n5 = bl ? -16777216 : -1;
                    bufferedImage.setRGB(j, i, n5);
                }
            }
            graphics2D.drawImage(bufferedImage, 0, 0, n / this.m_Resolution, n2 / this.m_Resolution, 0, 0, n, n2, this);
            bufferedImage.flush();
        }
        catch (WriterException writerException) {
            m_Logger.error((Object)("Unable to generate QRCode, " + writerException.getMessage()), (Throwable)writerException);
        }
    }

    @Override
    public void setAngleDegrees(double d) {
    }

    @Override
    public void setCode(String string) {
        this.m_Value = string;
        if (this.m_Value.length() > 1817) {
            m_Logger.warn((Object)"Max size for Kanji is 1817");
        }
    }

    public void setErrorCorrectionLevelValue(String string) {
        this.m_ErrorCorrection = string;
    }

    private ErrorCorrectionLevel getErrorCorrectionLevel() {
        if ("L".equals(this.m_ErrorCorrection)) {
            return ErrorCorrectionLevel.L;
        }
        if ("M".equals(this.m_ErrorCorrection)) {
            return ErrorCorrectionLevel.M;
        }
        if ("Q".equals(this.m_ErrorCorrection)) {
            return ErrorCorrectionLevel.Q;
        }
        if ("H".equals(this.m_ErrorCorrection)) {
            return ErrorCorrectionLevel.H;
        }
        return ErrorCorrectionLevel.L;
    }

    public String getCharacterSet() {
        return this.m_Encoding;
    }

    public void setCharacterSet(String string) {
        this.m_Encoding = string;
    }
}

