/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.border;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;

public class BorderPatrol {
    private Map<String, BufferedImage> m_Images;
    private static Set<String> m_SpecialNames = new HashSet<String>();

    public static void main(String[] stringArray) throws IOException {
        stringArray = new String[]{"C:\\Temp\\Borders"};
        if (stringArray.length < 1) {
            System.out.println("Usage: BorderPatrol dir");
            System.exit(-1);
        }
        BorderPatrol.patrol(new File(stringArray[0]));
    }

    protected static void patrol(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (BorderPatrol.isBorderDir(fileArray)) {
            new BorderPatrol(file);
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            BorderPatrol.patrol(file2);
        }
    }

    protected static boolean isBorderDir(File[] fileArray) {
        for (File file : fileArray) {
            if (!m_SpecialNames.contains(file.getName())) continue;
            return true;
        }
        return false;
    }

    protected BorderPatrol(File file) throws IOException {
        BufferedImage bufferedImage;
        File file2;
        File file3;
        System.out.println(file.getName());
        if (new File(file, "title.xml").exists()) {
            System.out.println(" + title");
        }
        if (!(file3 = new File(file, "sample.png")).exists()) {
            System.out.println(" - sample");
        }
        if (!(file2 = new File(file, "thumbnail.png")).exists()) {
            System.out.println(" - thumbnail");
        }
        if (!file3.getCanonicalPath().endsWith("sample.png")) {
            System.out.println(" - sample filename wrong");
        }
        if (!file2.getCanonicalPath().endsWith("thumbnail.png")) {
            System.out.println(" - thumbnail filename wrong");
        }
        if (file3.exists() && ((bufferedImage = ImageIO.read(file3)).getWidth() != 300 || bufferedImage.getHeight() != 300)) {
            System.out.println(" - sample image size: " + bufferedImage.getWidth() + "," + bufferedImage.getHeight());
        }
        if (file2.exists() && ((bufferedImage = ImageIO.read(file2)).getWidth() != 64 || bufferedImage.getHeight() != 64)) {
            System.out.println(" - thumb image size: " + bufferedImage.getWidth() + "," + bufferedImage.getHeight());
        }
        this.loadImages(file);
        int n = this.getHeight("topleft.png");
        int n2 = this.getHeight("top.png");
        int n3 = this.getHeight("topright.png");
        if (!this.equal(n, n2, n3)) {
            System.out.println(" - Tops are different heights: " + n + "," + n2 + "," + n3);
        }
        if (!this.equal(n = this.getHeight("bottomleft.png"), n2 = this.getHeight("bottom.png"), n3 = this.getHeight("bottomright.png"))) {
            System.out.println(" - Bottoms are different heights: " + n + "," + n2 + "," + n3);
        }
    }

    protected boolean equal(int n, int n2, int n3) {
        BitSet bitSet = new BitSet();
        bitSet.set(n);
        bitSet.set(n2);
        bitSet.set(n3);
        int n4 = bitSet.nextSetBit(1);
        if (n4 < 0) {
            return true;
        }
        return bitSet.nextSetBit(n4 + 1) < 0;
    }

    protected int getWidth(String string) {
        BufferedImage bufferedImage = this.m_Images.get(string);
        return bufferedImage == null ? 0 : bufferedImage.getWidth();
    }

    protected int getHeight(String string) {
        BufferedImage bufferedImage = this.m_Images.get(string);
        return bufferedImage == null ? 0 : bufferedImage.getHeight();
    }

    protected void loadImages(File file) {
        this.m_Images = new HashMap<String, BufferedImage>();
        for (String string : m_SpecialNames) {
            BufferedImage bufferedImage = BorderPatrol.loadImage(new File(file, string));
            if (bufferedImage == null) continue;
            this.m_Images.put(string, bufferedImage);
        }
    }

    protected static BufferedImage loadImage(File file) {
        if (file.exists()) {
            try {
                return ImageIO.read(file);
            }
            catch (IOException iOException) {
                System.out.println(" - Bad image file: " + file.getAbsolutePath());
            }
        }
        return null;
    }

    static {
        m_SpecialNames.add("top.png");
        m_SpecialNames.add("topleft.png");
        m_SpecialNames.add("topright.png");
        m_SpecialNames.add("bottom.png");
        m_SpecialNames.add("bottomleft.png");
        m_SpecialNames.add("bottomright.png");
        m_SpecialNames.add("left.png");
        m_SpecialNames.add("right.png");
    }
}

