/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.border;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.border.Title;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.border.Border;

public class ImageBorder
implements Border {
    private BufferedImage m_TLCorner;
    private BufferedImage m_TRCorner;
    private BufferedImage m_BLCorner;
    private BufferedImage m_BRCorner;
    private BufferedImage m_T;
    private BufferedImage m_L;
    private BufferedImage m_B;
    private BufferedImage m_R;
    private Title m_Title;

    public static ImageBorder getBorder(String string, ArgumentMap.ICallback iCallback) {
        ImageBorder imageBorder = new ImageBorder();
        Repository repository = (Repository)Elixir.get(Repository.class);
        FileObject fileObject = repository.getFileJ(string);
        if (fileObject == null || fileObject.isData()) {
            return null;
        }
        imageBorder.setT(ImageBorder.getImage(fileObject, "top.png"));
        imageBorder.setL(ImageBorder.getImage(fileObject, "left.png"));
        imageBorder.setB(ImageBorder.getImage(fileObject, "bottom.png"));
        imageBorder.setR(ImageBorder.getImage(fileObject, "right.png"));
        imageBorder.setTLCorner(ImageBorder.getImage(fileObject, "topleft.png"));
        imageBorder.setTRCorner(ImageBorder.getImage(fileObject, "topright.png"));
        imageBorder.setBLCorner(ImageBorder.getImage(fileObject, "bottomleft.png"));
        imageBorder.setBRCorner(ImageBorder.getImage(fileObject, "bottomright.png"));
        imageBorder.setTitle(ImageBorder.getTitle(fileObject, "title.xml", iCallback));
        return imageBorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getImage(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getChildJ(string);
        if (fileObject2 == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = fileObject2.getInputStream();
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException iOException) {
            ElxLoggerJ.getLogger(ImageBorder.class).warn((Object)("Can't read image at " + String.valueOf(fileObject2.getPath()) + ": " + String.valueOf(iOException)), (Throwable)iOException);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            FileUtil.close(inputStream);
        }
    }

    public static Title getTitle(FileObject fileObject, String string, ArgumentMap.ICallback iCallback) {
        FileObject fileObject2 = fileObject.getChildJ(string);
        if (fileObject2 == null) {
            return null;
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(fileObject2.getInputStream());
            Element element = document.getRootElement();
            Title title = new Title();
            title.setX(element.getAttributeValue("x"));
            title.setY(element.getAttributeValue("y"));
            title.setFontName(element.getAttributeValue("font-name"));
            title.setFontSize(element.getAttributeValue("font-size"));
            title.setFontBold(element.getAttributeValue("font-bold"));
            title.setFontItalic(element.getAttributeValue("font-italic"));
            title.setFontUnderline(element.getAttributeValue("font-underline"));
            title.setFontStrikethrough(element.getAttributeValue("font-strikethrough"));
            title.setFontColor(element.getAttributeValue("font-color"));
            title.setTextAlign(element.getAttributeValue("text-align"));
            title.setCallback(iCallback);
            return title;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setB(BufferedImage bufferedImage) {
        this.m_B = bufferedImage;
    }

    public void setBLCorner(BufferedImage bufferedImage) {
        this.m_BLCorner = bufferedImage;
    }

    public void setBRCorner(BufferedImage bufferedImage) {
        this.m_BRCorner = bufferedImage;
    }

    public void setL(BufferedImage bufferedImage) {
        this.m_L = bufferedImage;
    }

    public void setR(BufferedImage bufferedImage) {
        this.m_R = bufferedImage;
    }

    public void setT(BufferedImage bufferedImage) {
        this.m_T = bufferedImage;
    }

    public void setTLCorner(BufferedImage bufferedImage) {
        this.m_TLCorner = bufferedImage;
    }

    public void setTRCorner(BufferedImage bufferedImage) {
        this.m_TRCorner = bufferedImage;
    }

    public void setTitle(Title title) {
        this.m_Title = title;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        Insets insets = new Insets(this.getTopInset(), this.getLeftInset(), this.getBottomInset(), this.getRightInset());
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setText(String string) {
        if (this.m_Title != null) {
            this.m_Title.setText(string);
        }
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n + n3;
        int n7 = n;
        int n8 = n + n3;
        int n9 = n2;
        int n10 = n2 + n4;
        int n11 = n2;
        int n12 = n2 + n4;
        if (this.m_TLCorner != null) {
            graphics.drawImage(this.m_TLCorner, n, n2, null);
            n5 = n + this.m_TLCorner.getWidth();
            n9 = n2 + this.m_TLCorner.getHeight();
        }
        if (this.m_TRCorner != null) {
            graphics.drawImage(this.m_TRCorner, n + n3 - this.m_TRCorner.getWidth(), n2, null);
            n6 = n + n3 - this.m_TRCorner.getWidth();
            n11 = n2 + this.m_TRCorner.getHeight();
        }
        if (this.m_BLCorner != null) {
            graphics.drawImage(this.m_BLCorner, n, n2 + n4 - this.m_BLCorner.getHeight(), null);
            n7 = n + this.m_BLCorner.getWidth();
            n10 = n2 + n4 - this.m_BLCorner.getHeight();
        }
        if (this.m_BRCorner != null) {
            graphics.drawImage(this.m_BRCorner, n + n3 - this.m_BRCorner.getWidth(), n2 + n4 - this.m_BRCorner.getHeight(), null);
            n8 = n + n3 - this.m_BRCorner.getWidth();
            n12 = n2 + n4 - this.m_BRCorner.getHeight();
        }
        if (this.m_T != null) {
            this.hdraw(graphics, this.m_T, n2, n5, n6);
        }
        if (this.m_B != null) {
            this.hdraw(graphics, this.m_B, n2 + n4 - this.m_B.getHeight(), n7, n8);
        }
        if (this.m_L != null) {
            this.vdraw(graphics, this.m_L, n, n9, n10);
        }
        if (this.m_R != null) {
            this.vdraw(graphics, this.m_R, n + n3 - this.m_R.getWidth(), n11, n12);
        }
        if (this.m_Title != null) {
            this.m_Title.paint((Graphics2D)graphics, new Rectangle(n, n2, n3, n4));
        }
    }

    protected void hdraw(Graphics graphics, BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        Shape shape = graphics.getClip();
        graphics.clipRect(n2, n, n3 - n2, n5);
        for (int i = n2; i < n3; i += n4) {
            graphics.drawImage(bufferedImage, i, n, null);
        }
        graphics.setClip(shape);
    }

    protected void vdraw(Graphics graphics, BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        Shape shape = graphics.getClip();
        graphics.clipRect(n, n2, n4, n3 - n2);
        for (int i = n2; i < n3; i += n5) {
            graphics.drawImage(bufferedImage, n, i, null);
        }
        graphics.setClip(shape);
    }

    protected int getTopInset() {
        return this.m_T != null ? this.m_T.getHeight() : 0;
    }

    protected int getLeftInset() {
        return this.m_L != null ? this.m_L.getWidth() : 0;
    }

    protected int getBottomInset() {
        return this.m_B != null ? this.m_B.getHeight() : 0;
    }

    protected int getRightInset() {
        return this.m_R != null ? this.m_R.getWidth() : 0;
    }
}

