/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.border;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;

public class Title {
    private String m_X = "6";
    private String m_Y = "2";
    private String m_FontName = "Arial";
    private String m_FontSize = "12";
    private String m_IsFontBold = "No";
    private String m_IsFontItalic = "No";
    private String m_IsFontUnderline = "No";
    private String m_IsFontStrikethrough = "No";
    private String m_FontColor = "Black";
    private String m_TextAlign = "Left";
    private String m_Text;
    private ArgumentMap.ICallback m_Callback;

    public void setX(String string) {
        this.m_X = string;
    }

    public void setY(String string) {
        this.m_Y = string;
    }

    public void setFontName(String string) {
        if (string != null) {
            this.m_FontName = string;
        }
    }

    public void setFontSize(String string) {
        if (string != null) {
            this.m_FontSize = string;
        }
    }

    public void setFontBold(String string) {
        if (string != null) {
            this.m_IsFontBold = string;
        }
    }

    public void setFontItalic(String string) {
        if (string != null) {
            this.m_IsFontItalic = string;
        }
    }

    public void setFontUnderline(String string) {
        if (string != null) {
            this.m_IsFontUnderline = string;
        }
    }

    public void setFontStrikethrough(String string) {
        if (string != null) {
            this.m_IsFontStrikethrough = string;
        }
    }

    public void setFontColor(String string) {
        if (string != null) {
            this.m_FontColor = string;
        }
    }

    public void setTextAlign(String string) {
        if (string != null) {
            this.m_TextAlign = string;
        }
    }

    public void setCallback(ArgumentMap.ICallback iCallback) {
        this.m_Callback = iCallback;
    }

    public void setText(String string) {
        this.m_Text = string;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        if (StringUtil.isEmpty(this.m_Text)) {
            return;
        }
        Color color = StandardColor.lookup(this.substitute(this.m_FontColor), Color.BLACK);
        AttributedString attributedString = new AttributedString(this.substitute(this.m_Text));
        attributedString.addAttribute(TextAttribute.FONT, this.buildFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        boolean bl = this.getBoolean(this.m_IsFontUnderline);
        boolean bl2 = this.getBoolean(this.m_IsFontStrikethrough);
        if (bl) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (bl2) {
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        int n = this.getInt(this.m_X, rectangle.width);
        int n2 = this.getInt(this.m_Y, rectangle.height);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        if ("Center".equals(this.m_TextAlign)) {
            if (n == 0) {
                int n3 = (int)textLayout.getAdvance();
                n = (rectangle.width - n3) / 2;
            } else {
                n = (int)((float)n - textLayout.getAdvance() / 2.0f);
            }
        } else if ("Right".equals(this.m_TextAlign)) {
            n = (int)((float)n - textLayout.getAdvance());
        }
        n2 = (int)((float)n2 + (textLayout.getAscent() + 1.0f));
        graphics2D.drawString(attributedString.getIterator(), rectangle.x + n, rectangle.y + n2);
    }

    protected int getInt(String string, int n) {
        string = this.substitute(string);
        boolean bl = false;
        if ((string = string.trim()).endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            n2 = n2 * n / 100;
        }
        if (n2 < 0) {
            n2 = n + n2;
        }
        return n2;
    }

    protected boolean getBoolean(String string) {
        string = this.substitute(string);
        return "Yes".equalsIgnoreCase(string);
    }

    protected Font buildFont() {
        boolean bl = "Yes".equalsIgnoreCase(this.substitute(this.m_IsFontBold));
        boolean bl2 = "Yes".equalsIgnoreCase(this.substitute(this.m_IsFontItalic));
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        int n2 = 12;
        try {
            n2 = Integer.parseInt(this.substitute(this.m_FontSize));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Font(this.m_FontName, n, n2);
    }

    protected String substitute(String string) {
        if (this.m_Callback == null) {
            return string;
        }
        return ArgumentMap.substitute((String)string, (ArgumentMap.ICallback)this.m_Callback);
    }
}

