/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.commands;

import com.elixirtech.canvas.commands.AbstractCommand;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.graph.Node;
import java.awt.Point;

public class CreationCmd
extends AbstractCommand {
    private Node m_Node;
    private GO m_GO;
    private GO[] m_PrevSel;
    private Diagram m_Diagram;
    private Point m_Point;

    public CreationCmd(ICanvas iCanvas, Node node, GO gO) {
        super(iCanvas);
        assert (gO != null);
        this.m_Node = node;
        this.m_GO = gO;
        this.m_PrevSel = this.getSelectionManager().getSelections();
    }

    @Override
    public void doIt() {
        this.getSelectionManager().setSelection(this.m_GO);
        this.storeDiagram();
    }

    @Override
    public void undoIt() {
        if (this.m_Node != null) {
            this.m_Node.disconnect();
        }
        this.m_GO.disconnect();
        this.showDiagram();
        this.m_Canvas.drawShape(this.m_GO);
        this.getSelectionManager().setSelections(this.m_PrevSel);
    }

    @Override
    public void redoIt() {
        if (this.m_Node != null) {
            this.m_Node.reconnect();
        }
        this.m_GO.reconnect();
        this.showDiagram();
        this.getSelectionManager().setSelection(this.m_GO);
    }

    private void storeDiagram() {
        this.m_Diagram = this.m_Canvas.getDiagram();
        this.m_Point = this.m_Canvas.getScrollPosition();
    }

    private void showDiagram() {
        this.m_Canvas.setDiagram(this.m_Diagram, this.m_Point);
    }
}

