/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.commands;

import com.elixirtech.canvas.commands.AbstractCommand;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import java.util.HashSet;
import java.util.Set;

public final class DeleteCmd
extends AbstractCommand {
    private GO[] m_Selections;
    private Set<Node> m_Deleted = new HashSet<Node>();
    private RectangleEx m_RepaintRc;

    public DeleteCmd(ICanvas iCanvas) {
        super(iCanvas);
    }

    @Override
    public void doIt() {
        SelectionManager selectionManager = this.getSelectionManager();
        this.m_RepaintRc = selectionManager.getSelectionRect();
        this.m_Selections = selectionManager.getSelections();
        for (int i = 0; i < this.m_Selections.length; ++i) {
            this.m_Selections[i].buildDeleteSet(this.m_Deleted);
        }
        this.disconnectShapes();
        selectionManager.removeAllSelections();
        for (GO gO : this.m_Deleted) {
            this.m_RepaintRc = this.m_RepaintRc.union(GOExtras.getPaintRect(gO));
        }
        this.draw(this.m_RepaintRc);
    }

    @Override
    public void undoIt() {
        SelectionManager selectionManager = this.getSelectionManager();
        this.reconnectShapes();
        selectionManager.setSelections(this.m_Selections);
        this.draw(this.m_RepaintRc);
    }

    @Override
    public void redoIt() {
        SelectionManager selectionManager = this.getSelectionManager();
        this.disconnectShapes();
        selectionManager.removeAllSelections();
        this.draw(this.m_RepaintRc);
    }

    private void disconnectShapes() {
        for (Node node : this.m_Deleted) {
            node.disconnect();
        }
    }

    private void reconnectShapes() {
        for (Node node : this.m_Deleted) {
            node.reconnect();
        }
    }

    private void draw(RectangleEx rectangleEx) {
        this.m_Canvas.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
    }
}

