/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.commands;

import com.elixirtech.canvas.commands.AbstractCommand;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.graph.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DeleteNodeCmd
extends AbstractCommand {
    private Set<Node> m_Deleted = new HashSet<Node>();
    private GO[] m_OldSelections;
    private Node m_Node;

    public DeleteNodeCmd(ICanvas iCanvas, Node node) {
        super(iCanvas);
        this.m_Node = node;
    }

    @Override
    public void doIt() {
        this.m_OldSelections = this.getSelectionManager().getSelections();
        this.m_Node.buildDeleteSet(this.m_Deleted);
        this.disconnectNodes();
        this.removeSelections();
        this.m_Canvas.refresh();
    }

    @Override
    public void undoIt() {
        this.reconnectNodes();
        this.restoreSelections();
        this.m_Canvas.refresh();
    }

    @Override
    public void redoIt() {
        this.disconnectNodes();
        this.removeSelections();
        this.m_Canvas.refresh();
    }

    private void removeSelections() {
        ArrayList<GO> arrayList = new ArrayList<GO>();
        for (int i = 0; i < this.m_OldSelections.length; ++i) {
            GO gO = this.m_OldSelections[i];
            if (this.m_Deleted.contains(gO)) continue;
            arrayList.add(gO);
        }
        GO[] gOArray = new GO[arrayList.size()];
        arrayList.toArray(gOArray);
        this.getSelectionManager().setSelections(gOArray);
    }

    private void restoreSelections() {
        this.getSelectionManager().setSelections(this.m_OldSelections);
    }

    private void disconnectNodes() {
        for (Node node : this.m_Deleted) {
            node.disconnect();
        }
    }

    private void reconnectNodes() {
        for (Node node : this.m_Deleted) {
            node.reconnect();
        }
    }
}

