/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.commands;

import com.elixirtech.canvas.commands.AbstractCommand;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.geometry.RectangleEx;

public final class MoveCmd
extends AbstractCommand {
    private GO[] m_Selections;
    private int m_OffsetX;
    private int m_OffsetY;

    public MoveCmd(ICanvas iCanvas, int n, int n2) {
        super(iCanvas);
        this.m_OffsetX = n;
        this.m_OffsetY = n2;
    }

    @Override
    public void doIt() {
        this.m_Selections = this.getSelectionManager().getSelections();
        this.moveSelections(this.m_OffsetX, this.m_OffsetY);
    }

    @Override
    public void undoIt() {
        this.getSelectionManager().setSelections(this.m_Selections);
        this.moveSelections(-this.m_OffsetX, -this.m_OffsetY);
    }

    @Override
    public void redoIt() {
        this.getSelectionManager().setSelections(this.m_Selections);
        this.moveSelections(this.m_OffsetX, this.m_OffsetY);
    }

    private void moveSelections(int n, int n2) {
        SelectionManager selectionManager = this.getSelectionManager();
        RectangleEx rectangleEx = selectionManager.getSelectionPaintRect();
        selectionManager.moveSelections(n, n2);
        RectangleEx rectangleEx2 = selectionManager.getSelectionPaintRect();
        RectangleEx rectangleEx3 = rectangleEx.union(rectangleEx2);
        this.draw(rectangleEx3);
    }

    private void draw(RectangleEx rectangleEx) {
        this.m_Canvas.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
    }
}

