/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.commands;

import com.elixirtech.canvas.commands.AbstractCommand;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;

public final class PasteCmd
extends AbstractCommand {
    protected GO[] m_GOs;
    private GO[] m_OldSelections;

    public PasteCmd(ICanvas iCanvas, GO[] gOArray) {
        super(iCanvas);
        this.m_GOs = new GO[gOArray.length];
        for (int i = 0; i < this.m_GOs.length; ++i) {
            this.m_GOs[i] = gOArray[i];
        }
    }

    @Override
    public void doIt() {
        SelectionManager selectionManager = this.getSelectionManager();
        this.m_OldSelections = selectionManager.getSelections();
        Diagram diagram = this.m_Canvas.getDiagram();
        for (int i = 0; i < this.m_GOs.length; ++i) {
            GO gO = this.m_GOs[i];
            diagram.connectTo((Node)gO, RelType.Owns);
        }
        selectionManager.setSelections(this.m_GOs);
        this.m_Canvas.refresh();
    }

    @Override
    public void undoIt() {
        for (int i = 0; i < this.m_GOs.length; ++i) {
            GO gO = this.m_GOs[i];
            gO.disconnect();
        }
        this.getSelectionManager().setSelections(this.m_OldSelections);
        this.m_Canvas.refresh();
    }

    @Override
    public void redoIt() {
        for (int i = 0; i < this.m_GOs.length; ++i) {
            GO gO = this.m_GOs[i];
            gO.reconnect();
        }
        this.getSelectionManager().setSelections(this.m_GOs);
        this.m_Canvas.refresh();
    }
}

