/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.commands;

import com.elixirtech.canvas.commands.AbstractCommand;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.Handle;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.SelectionManager;
import com.elixirtech.canvas.geometry.RectangleEx;

public class SelectCmd
extends AbstractCommand {
    private GO[] m_OldSelections;
    private GO[] m_NewSelections;
    private RectangleEx m_OldRc;
    private RectangleEx m_NewRc;

    public SelectCmd(ICanvas iCanvas, GO[] gOArray) {
        super(iCanvas);
        this.m_NewSelections = new GO[gOArray.length];
        for (int i = 0; i < this.m_NewSelections.length; ++i) {
            this.m_NewSelections[i] = gOArray[i];
        }
    }

    @Override
    public void doIt() {
        SelectionManager selectionManager = this.getSelectionManager();
        this.m_OldSelections = selectionManager.getSelections();
        this.m_OldRc = selectionManager.getSelectionRect().grow(Handle.HANDLESZ());
        selectionManager.setSelections(this.m_NewSelections);
        this.m_NewRc = selectionManager.getSelectionRect().grow(Handle.HANDLESZ());
        this.repaint();
    }

    @Override
    public void undoIt() {
        this.getSelectionManager().setSelections(this.m_OldSelections);
        this.repaint();
    }

    @Override
    public void redoIt() {
        this.getSelectionManager().setSelections(this.m_NewSelections);
        this.repaint();
    }

    private void repaint() {
        this.m_Canvas.drawRect(this.m_OldRc.left, this.m_OldRc.top, this.m_OldRc.width(), this.m_OldRc.height());
        this.m_Canvas.drawRect(this.m_NewRc.left, this.m_NewRc.top, this.m_NewRc.width(), this.m_NewRc.height());
    }
}

