/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.I18N;
import com.elixirtech.canvas.corego.ConnectorGO;
import com.elixirtech.canvas.corego.ConnectorGOHelper$;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras$;
import com.elixirtech.canvas.corego.Handle;
import com.elixirtech.canvas.corego.Handle$;
import com.elixirtech.canvas.corego.HandleOwner;
import com.elixirtech.canvas.corego.HandleOwner$;
import com.elixirtech.canvas.corego.PolylineConnectorGO;
import com.elixirtech.canvas.corego.PolylineConnectorGOHelper;
import com.elixirtech.canvas.diagram.DiagramSelectionManager;
import com.elixirtech.canvas.extras.DiagramExtras$;
import com.elixirtech.canvas.extras.DiagramWrapper;
import com.elixirtech.canvas.geometry.Geometry;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public final class PolylineConnectorGOHelper$
implements Serializable {
    private static final int HANDLE_ID_BASE;
    private static final int HIT_RADIUS;
    public static final PolylineConnectorGOHelper$ MODULE$;

    private PolylineConnectorGOHelper$() {
    }

    static {
        MODULE$ = new PolylineConnectorGOHelper$();
        HANDLE_ID_BASE = 100;
        HIT_RADIUS = 6;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PolylineConnectorGOHelper$.class);
    }

    public int HANDLE_ID_BASE() {
        return HANDLE_ID_BASE;
    }

    public int HIT_RADIUS() {
        return HIT_RADIUS;
    }

    public List<Handle> buildHandles(PolylineConnectorGO go, boolean editable) {
        HandleOwner ho = HandleOwner$.MODULE$.apply((GO)go);
        ListBuffer list = new ListBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), go.getPoints().length - 1).foreach((Function1 & Serializable)i -> PolylineConnectorGOHelper$.buildHandles$$anonfun$1(list, ho, editable, BoxesRunTime.unboxToInt((Object)i)));
        return ((ListBuffer)list.$plus$plus(ConnectorGOHelper$.MODULE$.buildHandles((ConnectorGO)go, editable))).toList();
    }

    public Option<Point> getHandlePoint(Handle h, PolylineConnectorGO go) {
        int i = h.getId();
        if (i >= this.HANDLE_ID_BASE()) {
            return Some$.MODULE$.apply((Object)go.getPoints()[i - this.HANDLE_ID_BASE() + 1]);
        }
        return ConnectorGOHelper$.MODULE$.getHandlePoint(h, (ConnectorGO)go);
    }

    public void setHandlePoint(Handle h, Point pt, PolylineConnectorGO go) {
        int id = h.getId();
        Point[] pts = go.getPoints();
        Point[] unsafepts = go.getUnsafePoints();
        if (id >= this.HANDLE_ID_BASE()) {
            int i = id - this.HANDLE_ID_BASE() + 1;
            if (i > 0) {
                ConnectorGOHelper$.MODULE$.alignPoint(pt, pts[i - 1]);
            }
            if (i < pts.length - 1) {
                ConnectorGOHelper$.MODULE$.alignPoint(pt, pts[i + 1]);
            }
            unsafepts[i].x = Math.max(0, pt.x);
            unsafepts[i].y = Math.max(0, pt.y);
            return;
        }
        int n = id;
        if (1 == n) {
            ConnectorGOHelper$.MODULE$.alignPoint(pt, pts[1]);
            Point pt1 = go.getStart().snapToEdge(pt);
            go.getStart().setPoint(pt1);
            return;
        }
        if (2 == n) {
            ConnectorGOHelper$.MODULE$.alignPoint(pt, pts[pts.length - 2]);
            Point pt2 = go.getStop().snapToEdge(pt);
            go.getStop().setPoint(pt2);
            return;
        }
        throw Scala3RunTime$.MODULE$.assertFailed((Object)"dead end");
    }

    public JPopupMenu getPopupMenu(PolylineConnectorGO go, Point pt) {
        boolean editable = DiagramExtras$.MODULE$.getWrapper(go.getDiagram()).isEditable();
        JPopupMenu pm = GOExtras$.MODULE$.goPopup((GO)go, pt);
        pm.addSeparator();
        JMenuItem mi = new JMenuItem(I18N.CANVAS.getString("PolylineConnectorGO.AddNode"));
        mi.addActionListener(new PolylineConnectorGOHelper.AddNodeListener(go, pt));
        mi.setEnabled(editable);
        pm.add(mi);
        mi = new JMenuItem(I18N.CANVAS.getString("PolylineConnectorGO.DeleteNode"));
        mi.addActionListener(new PolylineConnectorGOHelper.DeleteNodeListener(go, pt));
        mi.setEnabled(editable && this.hitsNode(go, pt));
        pm.add(mi);
        return pm;
    }

    public int addNewNode(PolylineConnectorGO go, Point pt) {
        Point[] pts = go.getPoints();
        IntRef idx = IntRef.create((int)0);
        DoubleRef len = DoubleRef.create((double)Double.MAX_VALUE);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), pts.length - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Point start = pts[i];
            Point stop = pts[i + 1];
            double dist = Geometry.distanceToLine((Point)start, (Point)stop, (Point)pt);
            if (dist < len$1.elem) {
                idx$1.elem = i;
                len$1.elem = dist;
                return;
            }
        });
        Point newPt = Geometry.closestPointOnLine((Point)pts[idx.elem], (Point)pts[idx.elem + 1], (Point)pt);
        Point[] newPts = new Point[pts.length + 1];
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), idx.elem).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            newPts$1[i] = (Point)pts[i].clone();
        });
        newPts[idx.elem + 1] = (Point)newPt.clone();
        Dimension grid = DiagramExtras$.MODULE$.getGridSize();
        Point point = newPts[idx.elem + 1];
        point.x -= newPts[idx.elem + 1].x % grid.width;
        Point point2 = newPts[idx.elem + 1];
        point2.y -= newPts[idx.elem + 1].y % grid.height;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(idx.elem + 1), pts.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            newPts$2[i + 1] = (Point)pts[i].clone();
        });
        go.setUnsafePoints(newPts);
        DiagramSelectionManager sm = DiagramExtras$.MODULE$.getWrapper(go.getDiagram()).getSelectionManager();
        sm.buildSelectionCache();
        RectangleEx rc = go.getPaintRect();
        rc.grow(Handle$.MODULE$.HANDLESZ());
        DiagramExtras$.MODULE$.getWrapper(go.getDiagram()).getCanvas().drawRect(rc.left, rc.top, rc.width(), rc.height());
        return idx.elem + 1;
    }

    public boolean hitsNode(PolylineConnectorGO go, Point pt) {
        Object[] pts = go.getPoints();
        Object object = Predef$.MODULE$.refArrayOps(pts);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(object, 1, pts.length - 2));
        return ArrayOps$.MODULE$.exists$extension(object2, (Function1 & Serializable)test -> {
            double dist = Geometry.distanceBetweenPoints((Point)test, (Point)pt);
            return dist < (double)MODULE$.HIT_RADIUS();
        });
    }

    public void removeNode(PolylineConnectorGO go, Point pt) {
        Object[] pts = go.getPoints();
        Object object = Predef$.MODULE$.refArrayOps(pts);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.slice$extension(object, 1, pts.length - 2));
        int index = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1 & Serializable)test -> {
            double dist = Geometry.distanceBetweenPoints((Point)test, (Point)pt);
            return dist < (double)MODULE$.HIT_RADIUS();
        }, ArrayOps$.MODULE$.indexWhere$default$2$extension(object2));
        if (index >= 0) {
            this.removeNode(go, index + 1);
            return;
        }
    }

    public void removeNode(PolylineConnectorGO go, int idx) {
        Object[] pts = go.getPoints();
        if (idx < 1) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (idx >= pts.length - 1) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        RectangleEx rc1 = GOExtras$.MODULE$.getPaintRect((GO)go);
        Object object = Predef$.MODULE$.refArrayOps(pts);
        Point[] newPts = (Point[])ArrayOps$.MODULE$.patch$extension(object, idx, (IterableOnce)package$.MODULE$.Nil(), 1, ClassTag$.MODULE$.apply(Point.class));
        go.setUnsafePoints(newPts);
        DiagramWrapper dw = DiagramExtras$.MODULE$.getWrapper(go.getDiagram());
        DiagramSelectionManager sm = dw.getSelectionManager();
        sm.buildSelectionCache();
        RectangleEx rc2 = GOExtras$.MODULE$.getPaintRect((GO)go);
        RectangleEx rc = rc1.union(rc2);
        rc.grow(Handle$.MODULE$.HANDLESZ());
        dw.getCanvas().drawRect(rc.left, rc.top, rc.width(), rc.height());
    }

    private static final /* synthetic */ ListBuffer buildHandles$$anonfun$1(ListBuffer list$1, HandleOwner ho$1, boolean editable$1, int i) {
        return (ListBuffer)list$1.$plus$eq((Object)new Handle(i - 1 + MODULE$.HANDLE_ID_BASE(), ho$1, 13, editable$1));
    }
}

