/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras$;
import com.elixirtech.canvas.corego.Handle;
import com.elixirtech.canvas.corego.Handle$;
import com.elixirtech.canvas.corego.HandleOwner;
import com.elixirtech.canvas.corego.HandleOwner$;
import com.elixirtech.canvas.corego.IParentGO;
import com.elixirtech.canvas.corego.RectGO;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;

public final class RectGOHelper$
implements Serializable {
    public static final RectGOHelper$ MODULE$ = new RectGOHelper$();

    private RectGOHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RectGOHelper$.class);
    }

    public void moveRect(RectGO go, int offx, int offy) {
        RectangleEx rect = go.getUnsafeRect();
        rect.move(offx, offy);
        IParentGO parent = go.getParentGO();
        rect.limitTo(GOExtras$.MODULE$.getChildRect(parent));
    }

    public void setPoint(Point pt, RectGO go) {
        RectangleEx rect = go.getUnsafeRect();
        rect.right = pt.x + rect.width();
        rect.bottom = pt.y + rect.height();
        rect.left = pt.x;
        rect.top = pt.y;
    }

    public List<Handle> buildHandles(RectGO go, boolean editable) {
        HandleOwner ho = HandleOwner$.MODULE$.apply((GO)go);
        return (List)new .colon.colon((Object)Handle$.MODULE$.apply(1, ho, 6, editable), (List)new .colon.colon((Object)Handle$.MODULE$.apply(2, ho, 7, editable), (List)new .colon.colon((Object)Handle$.MODULE$.apply(3, ho, 5, editable), (List)new .colon.colon((Object)Handle$.MODULE$.apply(4, ho, 4, editable), (List)Nil$.MODULE$))));
    }

    public Option<Point> getHandlePoint(Handle h, RectGO go) {
        RectangleEx rc = go.getRect();
        int n = h.getId();
        switch (n) {
            case 1: {
                return Some$.MODULE$.apply((Object)new Point(rc.left, rc.top));
            }
            case 2: {
                return Some$.MODULE$.apply((Object)new Point(rc.right, rc.top));
            }
            case 3: {
                return Some$.MODULE$.apply((Object)new Point(rc.right, rc.bottom));
            }
            case 4: {
                return Some$.MODULE$.apply((Object)new Point(rc.left, rc.bottom));
            }
        }
        throw Scala3RunTime$.MODULE$.assertFailed((Object)"dead end");
    }

    public void setHandlePoint(Handle h, Point pt, RectGO go) {
        RectangleEx rc = go.getUnsafeRect();
        Dimension minSize = go.getMinSize();
        int n = h.getId();
        switch (n) {
            case 1: {
                rc.left = pt.x;
                if (rc.width() < minSize.width) {
                    rc.left = rc.right - minSize.width;
                }
                rc.top = pt.y;
                if (rc.height() >= minSize.height) break;
                rc.top = rc.bottom - minSize.height;
                break;
            }
            case 2: {
                rc.right = pt.x;
                if (rc.width() < minSize.width) {
                    rc.right = rc.left + minSize.width;
                }
                rc.top = pt.y;
                if (rc.height() >= minSize.height) break;
                rc.top = rc.bottom - minSize.height;
                break;
            }
            case 3: {
                rc.right = pt.x;
                if (rc.width() < minSize.width) {
                    rc.right = rc.left + minSize.width;
                }
                rc.bottom = pt.y;
                if (rc.height() >= minSize.height) break;
                rc.bottom = rc.top + minSize.height;
                break;
            }
            case 4: {
                rc.left = pt.x;
                if (rc.width() < minSize.width) {
                    rc.left = rc.right - minSize.width;
                }
                rc.bottom = pt.y;
                if (rc.height() >= minSize.height) break;
                rc.bottom = rc.top + minSize.height;
                break;
            }
            default: {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"dead end");
            }
        }
        IParentGO parent = go.getParentGO();
        rc.limitTo(GOExtras$.MODULE$.getChildRect(parent));
    }

    public void drawBox(Graphics2D g, RectGO go) {
        RectangleEx rc = go.getRect();
        g.setColor(Color.white);
        g.fillRect(rc.left, rc.top, rc.width(), rc.height());
        g.setColor(Color.black);
        g.drawRect(rc.left, rc.top, rc.width(), rc.height());
    }
}

