/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.I18N;
import com.elixirtech.canvas.commands.CreationCmd;
import com.elixirtech.canvas.corego.ConnectorGO;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.diagram.DiagramCanvas;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.ICanvasContext;
import com.elixirtech.canvas.diagram.IPolicy;
import com.elixirtech.canvas.diagram.MouseTracker;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.extras.DiagramWrapper;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class ConnectorTool
extends MouseTracker {
    protected RectangleEx m_Container;
    protected PopupMenu m_Popup;
    protected IPolicy m_Policy;

    public ConnectorTool(IPolicy iPolicy) {
        this.m_Policy = iPolicy;
    }

    @Override
    public void register(Component component) {
        super.register(component);
        DiagramCanvas diagramCanvas = (DiagramCanvas)component;
        Dimension dimension = DiagramExtras.getDiagramSize();
        this.m_Container = new RectangleEx(0, 0, dimension.width, dimension.height);
    }

    public void setContainer(RectangleEx rectangleEx) {
        this.m_Container = rectangleEx;
    }

    public RectangleEx getRectangle() {
        RectangleEx rectangleEx = new RectangleEx(this.m_DownPoint, this.m_CurrentPoint);
        rectangleEx.normalize();
        if (rectangleEx.left < this.m_Container.left) {
            rectangleEx.left = this.m_Container.left;
        }
        if (rectangleEx.top < this.m_Container.top) {
            rectangleEx.top = this.m_Container.top;
        }
        if (rectangleEx.right > this.m_Container.right) {
            rectangleEx.right = this.m_Container.right;
        }
        if (rectangleEx.bottom > this.m_Container.bottom) {
            rectangleEx.bottom = this.m_Container.bottom;
        }
        return rectangleEx;
    }

    @Override
    public void draw() {
        this.m_Graphics.drawLine(this.m_DownPoint.x, this.m_DownPoint.y, this.m_CurrentPoint.x, this.m_CurrentPoint.y);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        int n = this.m_DownPoint.x - this.m_CurrentPoint.x;
        int n2 = this.m_DownPoint.y - this.m_CurrentPoint.y;
        ICanvas iCanvas = (ICanvas)((Object)mouseEvent.getComponent());
        DiagramWrapper diagramWrapper = DiagramExtras.getWrapper(iCanvas.getDiagram());
        if (Math.sqrt(n * n + n2 * n2) < 4.0) {
            Toolkit.getDefaultToolkit().beep();
            diagramWrapper.drawShapes();
            return;
        }
        if (!diagramWrapper.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            diagramWrapper.drawShapes();
            return;
        }
        GO gO = diagramWrapper.shapeAtPoint(this.m_DownPoint);
        if (gO == null) {
            this.getCanvasContext().displayWarning(I18N.CANVAS.getString("Warning.NoStartShape"));
            if (!mouseEvent.isAltDown()) {
                this.m_Toolbox.setDefaultSelection();
            }
            diagramWrapper.drawShapes();
            return;
        }
        GO gO2 = diagramWrapper.shapeAtPoint(this.m_CurrentPoint);
        if (gO2 == null) {
            this.getCanvasContext().displayWarning(I18N.CANVAS.getString("Warning.NoStopShape"));
            if (!mouseEvent.isAltDown()) {
                this.m_Toolbox.setDefaultSelection();
            }
            diagramWrapper.drawShapes();
            return;
        }
        try {
            DataFlowGO dataFlowGO = new DataFlowGO();
            this.connect(diagramWrapper.d(), (ConnectorGO)dataFlowGO, gO, gO2);
        }
        catch (Exception exception) {
            this.getCanvasContext().displayWarning(I18N.CANVAS.getString("Warning.ConnectionFailed") + " " + exception.getMessage());
        }
        diagramWrapper.drawShapes();
        if (!mouseEvent.isAltDown()) {
            this.m_Toolbox.setDefaultSelection();
        }
    }

    void connect(Diagram diagram, ConnectorGO connectorGO, GO gO, GO gO2) {
        Relationship relationship = connectorGO.createModel(gO.getModel(), gO2.getModel());
        try {
            diagram.connectTo((Node)connectorGO, RelType.Owns);
            Point point = gO.snapToEdge(this.m_DownPoint);
            Point point2 = gO2.snapToEdge(this.m_CurrentPoint);
            connectorGO.setStart(gO, point);
            connectorGO.setStop(gO2, point2);
            CreationCmd creationCmd = new CreationCmd(DiagramExtras.getWrapper(diagram).getCanvas(), (Node)relationship, (GO)connectorGO);
            DiagramExtras.getWrapper(diagram).doCommand(creationCmd);
        }
        catch (RuntimeException runtimeException) {
            connectorGO.disconnect();
            throw runtimeException;
        }
    }

    protected ICanvasContext getCanvasContext() {
        return ((ICanvas)((Object)this.m_Component)).getCanvasContext();
    }

    class PopupListener
    implements ActionListener {
        private ConnectorGO m_GO;
        private Diagram m_Diagram;
        private GO m_Src;
        private GO m_Dst;

        public PopupListener(ConnectorGO connectorGO, Diagram diagram, GO gO, GO gO2) {
            this.m_GO = connectorGO;
            this.m_Diagram = diagram;
            this.m_Src = gO;
            this.m_Dst = gO2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConnectorGO connectorGO = (ConnectorGO)this.m_GO.clone();
            ConnectorTool.this.connect(this.m_Diagram, connectorGO, this.m_Src, this.m_Dst);
        }
    }
}

