/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.diagram;

import com.elixirtech.canvas.I18N;
import com.elixirtech.canvas.commands.CreationCmd;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.GOExtras;
import com.elixirtech.canvas.corego.ParentGO;
import com.elixirtech.canvas.corego.RectGO;
import com.elixirtech.canvas.diagram.ICanvas;
import com.elixirtech.canvas.diagram.ICanvasContext;
import com.elixirtech.canvas.diagram.MouseTracker;
import com.elixirtech.canvas.extras.DiagramExtras;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.toolbox.ShapeChoice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

public class CreationTool
extends MouseTracker {
    private ICanvas m_Canvas;
    private Dimension m_Grid;
    private RectangleEx m_Container;
    private ShapeChoice m_Choice;

    public CreationTool(ShapeChoice shapeChoice) {
        this.m_Choice = shapeChoice;
    }

    @Override
    public void register(Component component) {
        super.register(component);
        this.m_Canvas = (ICanvas)((Object)component);
        Diagram diagram = this.m_Canvas.getDiagram();
        Dimension dimension = DiagramExtras.getDiagramSize();
        this.m_Container = new RectangleEx(0, 0, dimension.width, dimension.height);
        this.m_Grid = DiagramExtras.getGridSize();
    }

    public void setContainer(RectangleEx rectangleEx) {
        this.m_Container = rectangleEx;
    }

    public RectangleEx getRectangle() {
        RectangleEx rectangleEx = new RectangleEx(this.m_DownPoint, this.m_CurrentPoint);
        rectangleEx.normalize();
        if (rectangleEx.left < this.m_Container.left) {
            rectangleEx.left = this.m_Container.left;
        }
        if (rectangleEx.top < this.m_Container.top) {
            rectangleEx.top = this.m_Container.top;
        }
        if (rectangleEx.right > this.m_Container.right) {
            rectangleEx.right = this.m_Container.right;
        }
        if (rectangleEx.bottom > this.m_Container.bottom) {
            rectangleEx.bottom = this.m_Container.bottom;
        }
        return rectangleEx;
    }

    @Override
    public void draw() {
        RectangleEx rectangleEx = this.getRectangle();
        Stroke stroke = this.m_Graphics.getStroke();
        this.m_Graphics.setStroke(THIN_STROKE);
        this.m_Graphics.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width(), rectangleEx.height());
        this.m_Graphics.setStroke(stroke);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        Diagram diagram = this.m_Canvas.getDiagram();
        if (!DiagramExtras.getWrapper(diagram).isEditable()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        RectangleEx rectangleEx = this.getRectangle();
        RectGO rectGO = (RectGO)this.m_Choice.createGO();
        Node node = rectGO.getModel();
        if (rectangleEx.width() > 5 || rectangleEx.height() > 5) {
            rectGO.setRect(rectangleEx);
        } else {
            GOExtras.setPoint(this.m_DownPoint, (GO)rectGO);
        }
        ParentGO parentGO = DiagramExtras.getWrapper(diagram).getParentJ(this.m_DownPoint, (GO)rectGO);
        if (parentGO == null) {
            if (!DiagramExtras.isValidParent()) {
                this.getCanvasContext().displayWarning(I18N.CANVAS.getString("Warning.InvalidShape"));
                return;
            }
        } else {
            parentGO.connectTo((Node)rectGO, RelType.Contains);
        }
        diagram.connectTo((Node)rectGO, RelType.Owns);
        CreationCmd creationCmd = new CreationCmd(this.m_Canvas, node, (GO)rectGO);
        DiagramExtras.doCommand(diagram, creationCmd);
        DiagramExtras.getWrapper(diagram).drawShapes();
        assert (rectGO.getModel() == node);
        if (!mouseEvent.isAltDown()) {
            this.m_Toolbox.setDefaultSelection();
        }
    }

    @Override
    protected void setDownPoint(Point point) {
        point.x -= point.x % this.m_Grid.width;
        point.y -= point.y % this.m_Grid.height;
        super.setDownPoint(point);
    }

    @Override
    protected void setCurrentPoint(Point point) {
        point.x -= point.x % this.m_Grid.width;
        point.y -= point.y % this.m_Grid.height;
        super.setCurrentPoint(point);
    }

    protected ICanvasContext getCanvasContext() {
        return ((ICanvas)((Object)this.m_Component)).getCanvasContext();
    }
}

